/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.CacheAccessBackDoor;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.storageengine.api.CommandVersion;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.token.api.NamedToken;

public class NeoStoreTransactionApplier
extends TransactionApplier.Adapter {
    private final TransactionApplicationMode mode;
    private final CommandVersion version;
    private final NeoStores neoStores;
    private final CacheAccessBackDoor cacheAccess;
    private final IdUpdateListener idUpdateListener;
    private final CursorContext cursorContext;
    private final StoreCursors storeCursors;

    public NeoStoreTransactionApplier(TransactionApplicationMode mode, CommandVersion version, NeoStores neoStores, CacheAccessBackDoor cacheAccess, BatchContext batchContext, CursorContext cursorContext, StoreCursors storeCursors) {
        this.mode = mode;
        this.version = version;
        this.neoStores = neoStores;
        this.cacheAccess = cacheAccess;
        this.idUpdateListener = batchContext.getIdUpdateListener();
        this.cursorContext = cursorContext;
        this.storeCursors = storeCursors;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) {
        this.updateStore(this.neoStores.getNodeStore(), command, RecordCursorTypes.NODE_CURSOR);
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
        this.updateStore(this.neoStores.getRelationshipStore(), command, RecordCursorTypes.RELATIONSHIP_CURSOR);
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) {
        this.updateStore(this.neoStores.getPropertyStore(), command, RecordCursorTypes.PROPERTY_CURSOR);
        return false;
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) {
        this.updateStore(this.neoStores.getRelationshipGroupStore(), command, RecordCursorTypes.GROUP_CURSOR);
        return false;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) {
        this.updateStore(this.neoStores.getRelationshipTypeTokenStore(), command, RecordCursorTypes.REL_TYPE_TOKEN_CURSOR);
        if (!this.mode.isReverseStep()) {
            this.cacheAccess.addRelationshipTypeToken(this.getTokenFromTokenCommand(command), this.mode != TransactionApplicationMode.RECOVERY);
        }
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) {
        this.updateStore(this.neoStores.getLabelTokenStore(), command, RecordCursorTypes.LABEL_TOKEN_CURSOR);
        if (!this.mode.isReverseStep()) {
            this.cacheAccess.addLabelToken(this.getTokenFromTokenCommand(command), this.mode != TransactionApplicationMode.RECOVERY);
        }
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) {
        this.updateStore(this.neoStores.getPropertyKeyTokenStore(), command, RecordCursorTypes.PROPERTY_KEY_TOKEN_CURSOR);
        if (!this.mode.isReverseStep()) {
            this.cacheAccess.addPropertyKeyToken(this.getTokenFromTokenCommand(command), this.mode != TransactionApplicationMode.RECOVERY);
        }
        return false;
    }

    private NamedToken getTokenFromTokenCommand(Command.TokenCommand<?> command) {
        byte[] data = AbstractDynamicStore.getFullByteArrayFromHeavyRecords(((TokenRecord)command.getAfter()).getNameRecords(), PropertyType.STRING);
        String name = PropertyStore.decodeString(data);
        return new NamedToken(name, command.tokenId(), command.isInternal());
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) {
        this.updateStore(this.neoStores.getSchemaStore(), command, RecordCursorTypes.SCHEMA_CURSOR);
        SchemaRule schemaRule = command.getSchemaRule();
        this.onSchemaRuleChange(command.getMode(), schemaRule);
        return false;
    }

    private void onSchemaRuleChange(Command.Mode commandMode, SchemaRule schemaRule) {
        if (commandMode == Command.Mode.DELETE) {
            this.cacheAccess.removeSchemaRuleFromCache(schemaRule);
        } else {
            this.cacheAccess.addSchemaRule(schemaRule);
        }
    }

    private <RECORD extends AbstractBaseRecord> void updateStore(CommonAbstractStore<RECORD, ?> store, Command.BaseCommand<RECORD> command, CursorType cursorType) {
        try (PageCursor cursor = this.storeCursors.writeCursor(cursorType);){
            store.updateRecord(this.selectRecordByCommandVersion(command), this.idUpdateListener, cursor, this.cursorContext, this.storeCursors);
        }
    }

    private <RECORD extends AbstractBaseRecord> RECORD selectRecordByCommandVersion(Command.BaseCommand<RECORD> command) {
        return (RECORD)(switch (this.version) {
            default -> throw new MatchException(null, null);
            case CommandVersion.BEFORE -> (AbstractBaseRecord)command.getBefore();
            case CommandVersion.AFTER -> (AbstractBaseRecord)command.getAfter();
        });
    }
}

