/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdSequenceProvider;
import org.neo4j.internal.recordstorage.PropertyTraverser;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.Value;

public class PropertyCreator {
    private final DynamicRecordAllocator stringRecordAllocator;
    private final DynamicRecordAllocator arrayRecordAllocator;
    private final PropertyTraverser traverser;
    private final CursorContext cursorContext;
    private final IdSequence propertyIdSequence;
    private final String storeFormat;

    public PropertyCreator(DynamicRecordAllocator stringRecordAllocator, DynamicRecordAllocator arrayRecordAllocator, PropertyTraverser traverser, IdSequenceProvider idSequenceProvider, CursorContext cursorContext, String storeFormat) {
        this.stringRecordAllocator = stringRecordAllocator;
        this.arrayRecordAllocator = arrayRecordAllocator;
        this.traverser = traverser;
        this.cursorContext = cursorContext;
        this.propertyIdSequence = idSequenceProvider.getIdSequence((Enum)StoreType.PROPERTY);
        this.storeFormat = storeFormat;
    }

    public <P extends PrimitiveRecord> void primitiveSetProperty(RecordAccess.RecordProxy<P, ?> primitiveRecordChange, int propertyKey, Value value, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords, MemoryTracker memoryTracker) {
        PropertyRecord freeHost;
        PropertyBlock block = this.encodePropertyValue(propertyKey, value, memoryTracker);
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
        RecordAccess.RecordProxy<PropertyRecord, PrimitiveRecord> freeHostProxy = null;
        RecordAccess.RecordProxy<PropertyRecord, PrimitiveRecord> existingHostProxy = null;
        long prop = primitive.getNextProp();
        while (prop != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyBlock existingBlock;
            RecordAccess.RecordProxy<PropertyRecord, PrimitiveRecord> proxy = propertyRecords.getOrLoad(prop, primitive);
            PropertyRecord propRecord = proxy.forReadingLinkage();
            assert (propRecord.inUse()) : propRecord;
            if (propRecord.hasSpaceFor(block)) {
                freeHostProxy = proxy;
                if (existingHostProxy != null) {
                    PropertyRecord freeHost2 = proxy.forChangingData();
                    freeHost2.addPropertyBlock(block);
                    freeHost2.setChanged(primitive);
                    assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
                    return;
                }
            }
            if ((existingBlock = propRecord.getPropertyBlock(propertyKey)) != null) {
                existingHostProxy = proxy;
                PropertyRecord existingHost = existingHostProxy.forChangingData();
                PropertyCreator.removeProperty(propertyKey, primitive, existingBlock, existingHost, existingHostProxy.getBefore());
                if (block.getSize() <= existingBlock.getSize() || existingHost.hasSpaceFor(block)) {
                    existingHost.addPropertyBlock(block);
                    assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
                    return;
                }
                if (freeHostProxy != null) {
                    PropertyRecord freeHost3 = freeHostProxy.forChangingData();
                    freeHost3.addPropertyBlock(block);
                    freeHost3.setChanged(primitive);
                    assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
                    return;
                }
            }
            prop = propRecord.getNextProp();
        }
        if (freeHostProxy == null) {
            freeHost = propertyRecords.create(this.propertyIdSequence.nextId(this.cursorContext), primitive, this.cursorContext).forChangingData();
            freeHost.setInUse(true);
            if (primitive.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                PropertyRecord prevProp = propertyRecords.getOrLoad(primitive.getNextProp(), primitive).forChangingLinkage();
                assert (prevProp.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue());
                prevProp.setPrevProp(freeHost.getId());
                freeHost.setNextProp(prevProp.getId());
                prevProp.setChanged(primitive);
            }
            ((PrimitiveRecord)primitiveRecordChange.forChangingLinkage()).setNextProp(freeHost.getId());
        } else {
            freeHost = (PropertyRecord)freeHostProxy.forChangingData();
        }
        freeHost.addPropertyBlock(block);
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
    }

    private static void removeProperty(int propertyKey, PrimitiveRecord primitive, PropertyBlock existingBlock, PropertyRecord host, PropertyRecord existingHostBefore) {
        host.removePropertyBlock(existingBlock.getKeyIndexId());
        host.setChanged(primitive);
        for (DynamicRecord record : existingBlock.getValueRecords()) {
            assert (record.inUse());
            record.setInUse(false, existingBlock.getType().intValue());
            host.addDeletedRecord(record);
        }
        PropertyBlock beforeBlock = existingHostBefore.getPropertyBlock(propertyKey);
        assert (beforeBlock != null);
        for (DynamicRecord beforeDynamicRecord : beforeBlock.getValueRecords()) {
            assert (beforeDynamicRecord.inUse());
            beforeDynamicRecord.setCreated();
        }
    }

    private PropertyBlock encodePropertyValue(int propertyKey, Value value, MemoryTracker memoryTracker) {
        PropertyBlock block = new PropertyBlock();
        PropertyStore.encodeValue(block, propertyKey, value, this.stringRecordAllocator, this.arrayRecordAllocator, this.cursorContext, memoryTracker, this.storeFormat);
        return block;
    }
}

