/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.internal.id.IdSequenceProvider;
import org.neo4j.internal.recordstorage.Loaders;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.MultiversionResourceLocker;
import org.neo4j.internal.recordstorage.PropertyCreator;
import org.neo4j.internal.recordstorage.PropertyDeleter;
import org.neo4j.internal.recordstorage.PropertyTraverser;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordChangeSet;
import org.neo4j.internal.recordstorage.RelationshipGroupGetter;
import org.neo4j.internal.recordstorage.RelationshipModifier;
import org.neo4j.internal.recordstorage.TransactionRecordState;
import org.neo4j.internal.recordstorage.id.BatchedTransactionIdSequenceProvider;
import org.neo4j.internal.recordstorage.id.TransactionIdSequenceProvider;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.store.DynamicAllocatorProvider;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StandardDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.cursor.StoreCursors;

class RecordStorageCommandCreationContext
implements CommandCreationContext {
    private final NeoStores neoStores;
    private final Config config;
    private final boolean multiVersioned;
    private final String format;
    private final TokenNameLookup tokenNameLookup;
    private final InternalLogProvider logProvider;
    private final int denseNodeThreshold;
    private KernelVersionProvider kernelVersionProvider;
    private PropertyCreator propertyCreator;
    private PropertyDeleter propertyDeleter;
    private RelationshipGroupGetter relationshipGroupGetter;
    private Loaders loaders;
    private CursorContext cursorContext;
    private StoreCursors storeCursors;
    private ResourceLocker locks;
    private final DynamicAllocatorProvider dynamicAllocatorProvider;
    private final IdSequenceProvider idSequenceProvider;

    RecordStorageCommandCreationContext(NeoStores neoStores, TokenNameLookup tokenNameLookup, InternalLogProvider logProvider, int denseNodeThreshold, Config config, boolean multiVersioned, String format) {
        this.tokenNameLookup = tokenNameLookup;
        this.logProvider = logProvider;
        this.denseNodeThreshold = denseNodeThreshold;
        this.neoStores = neoStores;
        this.config = config;
        this.multiVersioned = multiVersioned;
        this.format = format;
        this.idSequenceProvider = RecordStorageCommandCreationContext.createIdSequenceProvider(neoStores, multiVersioned);
        this.dynamicAllocatorProvider = new TransactionDynamicAllocatorProvider(neoStores, this.idSequenceProvider);
    }

    public void initialize(KernelVersionProvider kernelVersionProvider, CursorContext cursorContext, StoreCursors storeCursors, LongSupplier startTimeOfOldestExecutingTransaction, ResourceLocker locks, Supplier<LockTracer> lockTracer) {
        this.kernelVersionProvider = kernelVersionProvider;
        this.cursorContext = cursorContext;
        this.loaders = new Loaders(this.neoStores, storeCursors);
        this.storeCursors = storeCursors;
        this.locks = locks;
        this.relationshipGroupGetter = new RelationshipGroupGetter(ignored -> this.nextId(StoreType.RELATIONSHIP_GROUP), cursorContext);
        PropertyTraverser propertyTraverser = new PropertyTraverser();
        this.propertyDeleter = new PropertyDeleter(propertyTraverser, this.neoStores, this.tokenNameLookup, this.logProvider, this.config, cursorContext, storeCursors);
        this.propertyCreator = new PropertyCreator(this.dynamicAllocatorProvider.allocator(StoreType.PROPERTY_STRING), this.dynamicAllocatorProvider.allocator(StoreType.PROPERTY_ARRAY), propertyTraverser, this.idSequenceProvider, cursorContext, this.format);
    }

    public boolean resetIds() {
        return this.multiVersioned && this.idSequenceProvider.reset();
    }

    private long nextId(StoreType storeType) {
        return this.idSequenceProvider.getIdSequence((Enum)storeType).nextId(this.cursorContext);
    }

    ResourceLocker getLocks() {
        return this.locks;
    }

    public long reserveNode() {
        return this.nextId(StoreType.NODE);
    }

    public long reserveRelationship(long sourceNode, long targetNode, int relationshipType, boolean sourceNodeAddedInTx, boolean targetNodeAddedInTx) {
        return this.nextId(StoreType.RELATIONSHIP);
    }

    public long reserveSchema() {
        return this.nextId(StoreType.SCHEMA);
    }

    public int reserveRelationshipTypeTokenId(String tokenName) {
        return Math.toIntExact(this.nextId(StoreType.RELATIONSHIP_TYPE_TOKEN));
    }

    public int reservePropertyKeyTokenId(String tokenName) {
        return Math.toIntExact(this.nextId(StoreType.PROPERTY_KEY_TOKEN));
    }

    public int reserveLabelTokenId(String tokenName) {
        return Math.toIntExact(this.nextId(StoreType.LABEL_TOKEN));
    }

    public void close() {
        this.idSequenceProvider.release(this.cursorContext);
    }

    TransactionRecordState createTransactionRecordState(ResourceLocker locks, LockTracer lockTracer, LogCommandSerialization commandSerialization, MemoryTracker memoryTracker, RecordAccess.LoadMonitor monitor) {
        RecordChangeSet recordChangeSet = new RecordChangeSet(this.loaders, memoryTracker, monitor, this.storeCursors);
        ResourceLocker relationshipLocker = this.multiVersioned ? new MultiversionResourceLocker(locks, this.neoStores.getRelationshipStore()) : locks;
        RelationshipModifier relationshipModifier = new RelationshipModifier(this.relationshipGroupGetter, this.propertyDeleter, this.denseNodeThreshold, relationshipLocker, lockTracer, this.cursorContext, memoryTracker, this.multiVersioned);
        return new TransactionRecordState(this.kernelVersionProvider, recordChangeSet, this.neoStores, locks, lockTracer, relationshipModifier, this.propertyCreator, this.propertyDeleter, this.cursorContext, this.storeCursors, memoryTracker, commandSerialization, this.dynamicAllocatorProvider, this.idSequenceProvider);
    }

    public KernelVersion kernelVersion() {
        return this.kernelVersionProvider.kernelVersion();
    }

    private static IdSequenceProvider createIdSequenceProvider(NeoStores neoStores, boolean multiVersioned) {
        return multiVersioned ? new BatchedTransactionIdSequenceProvider(neoStores) : new TransactionIdSequenceProvider(neoStores);
    }

    private static class TransactionDynamicAllocatorProvider
    implements DynamicAllocatorProvider {
        private final StandardDynamicRecordAllocator[] dynamicAllocators = new StandardDynamicRecordAllocator[StoreType.STORE_TYPES.length];
        private final IdSequenceProvider idSequenceProvider;
        private final NeoStores neoStores;

        public TransactionDynamicAllocatorProvider(NeoStores neoStores, IdSequenceProvider idSequenceProvider) {
            this.neoStores = neoStores;
            this.idSequenceProvider = idSequenceProvider;
        }

        @Override
        public DynamicRecordAllocator allocator(StoreType type) {
            StandardDynamicRecordAllocator newAllocator;
            StandardDynamicRecordAllocator allocator = this.dynamicAllocators[type.ordinal()];
            if (allocator != null) {
                return allocator;
            }
            this.dynamicAllocators[type.ordinal()] = newAllocator = new StandardDynamicRecordAllocator(cursorContext -> this.idSequenceProvider.getIdSequence((Enum)type).nextId(cursorContext), this.neoStores.getRecordStore(type).getRecordDataSize());
            return newAllocator;
        }
    }
}

