/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.indexcommand.IndexUpdateCommand;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.storageengine.api.StorageCommand;

public class RecordStorageCommandHandling {
    public static void handleRecordStorageCommand(StorageCommand command, ThrowingConsumer<Command, IOException> recordCommandConsumer, ThrowingConsumer<IndexUpdateCommand<?>, IOException> indexUpdateCommandConsumer) throws IOException {
        StorageCommand storageCommand = command;
        Objects.requireNonNull(storageCommand);
        StorageCommand storageCommand2 = storageCommand;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Command.class, IndexUpdateCommand.class}, (Object)storageCommand2, n)) {
            case 0: {
                Command recordCommand = (Command)storageCommand2;
                recordCommandConsumer.accept((Object)recordCommand);
                break;
            }
            case 1: {
                IndexUpdateCommand indexUpdateCommand = (IndexUpdateCommand)storageCommand2;
                indexUpdateCommandConsumer.accept((Object)indexUpdateCommand);
                break;
            }
            default: {
                throw new IllegalArgumentException("StorageCommand of type " + command.getClass().getSimpleName() + " is not supported by this storage engine");
            }
        }
    }

    public static void handleRecordStorageCommands(Iterable<StorageCommand> commands, ThrowingConsumer<Command, IOException> recordCommandConsumer, ThrowingConsumer<IndexUpdateCommand<?>, IOException> indexUpdateCommandConsumer) throws IOException {
        for (StorageCommand command : commands) {
            RecordStorageCommandHandling.handleRecordStorageCommand(command, recordCommandConsumer, indexUpdateCommandConsumer);
        }
    }
}

