/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.Collection;
import java.util.Iterator;
import java.util.OptionalLong;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.counts.CountsStore;
import org.neo4j.counts.CountsVisitor;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.RecordNodeCursor;
import org.neo4j.internal.recordstorage.RecordNodeScan;
import org.neo4j.internal.recordstorage.RecordPropertyCursor;
import org.neo4j.internal.recordstorage.RecordRelationshipScan;
import org.neo4j.internal.recordstorage.RecordRelationshipScanCursor;
import org.neo4j.internal.recordstorage.RecordRelationshipTraversalCursor;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.StorageSchemaReaderSnapshot;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.AllNodeScan;
import org.neo4j.storageengine.api.AllRelationshipsScan;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;

public class RecordStorageReader
implements StorageReader {
    private final TokenHolders tokenHolders;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final RelationshipGroupStore relationshipGroupStore;
    private final PropertyStore propertyStore;
    private final CountsStore counts;
    private final RelationshipGroupDegreesStore groupDegreesStore;
    private final SchemaCache schemaCache;
    private boolean closed;

    RecordStorageReader(TokenHolders tokenHolders, NeoStores neoStores, CountsStore counts, RelationshipGroupDegreesStore groupDegreesStore, SchemaCache schemaCache) {
        this.tokenHolders = tokenHolders;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.propertyStore = neoStores.getPropertyStore();
        this.counts = counts;
        this.groupDegreesStore = groupDegreesStore;
        this.schemaCache = schemaCache;
    }

    public RecordStorageReader(NeoStores stores) {
        this(null, stores, null, null, null);
    }

    public RecordStorageReader(NeoStores stores, SchemaCache schemaCache) {
        this(null, stores, null, null, schemaCache);
    }

    public Iterator<IndexDescriptor> indexGetForSchema(SchemaDescriptor descriptor) {
        return this.schemaCache.indexesForSchema(descriptor);
    }

    public IndexDescriptor indexGetForSchemaAndType(SchemaDescriptor descriptor, IndexType type) {
        return this.schemaCache.indexForSchemaAndType(descriptor, type);
    }

    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        return this.schemaCache.indexesForLabel(labelId);
    }

    public Iterator<IndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        return this.schemaCache.indexesForRelationshipType(relationshipType);
    }

    public IndexDescriptor indexGetForName(String name) {
        return this.schemaCache.indexForName(name);
    }

    public ConstraintDescriptor constraintGetForName(String name) {
        return this.schemaCache.constraintForName(name);
    }

    public boolean indexExists(IndexDescriptor index) {
        return this.schemaCache.hasIndex(index);
    }

    public Iterator<IndexDescriptor> indexesGetAll() {
        return this.schemaCache.indexes().iterator();
    }

    public Collection<IndexDescriptor> valueIndexesGetRelated(int[] labels, int propertyKeyId, EntityType entityType) {
        return this.schemaCache.getValueIndexesRelatedTo(ArrayUtils.EMPTY_INT_ARRAY, labels, new int[]{propertyKeyId}, false, entityType);
    }

    public Collection<IndexDescriptor> valueIndexesGetRelated(int[] labels, int[] propertyKeyIds, EntityType entityType) {
        return this.schemaCache.getValueIndexesRelatedTo(labels, ArrayUtils.EMPTY_INT_ARRAY, propertyKeyIds, true, entityType);
    }

    public Collection<IndexBackedConstraintDescriptor> uniquenessConstraintsGetRelated(int[] tokens, int propertyKeyId, EntityType entityType) {
        return this.schemaCache.getUniquenessConstraintsRelatedTo(ArrayUtils.EMPTY_INT_ARRAY, tokens, new int[]{propertyKeyId}, false, entityType);
    }

    public Collection<IndexBackedConstraintDescriptor> uniquenessConstraintsGetRelated(int[] entityTokens, int[] propertyKeyIds, EntityType entityType) {
        return this.schemaCache.getUniquenessConstraintsRelatedTo(ArrayUtils.EMPTY_INT_ARRAY, entityTokens, propertyKeyIds, false, entityType);
    }

    public Collection<IndexBackedConstraintDescriptor> uniquenessConstraintsGetRelated(int[] changedLabels, int[] unchangedLabels, int[] propertyKeyIds, boolean propertyKeyListIsComplete, EntityType entityType) {
        return this.schemaCache.getUniquenessConstraintsRelatedTo(changedLabels, unchangedLabels, propertyKeyIds, propertyKeyListIsComplete, entityType);
    }

    public boolean hasRelatedSchema(int[] tokens, int propertyKey, EntityType entityType) {
        return this.schemaCache.hasRelatedSchema(tokens, propertyKey, entityType);
    }

    public boolean hasRelatedSchema(int token, EntityType entityType) {
        return this.schemaCache.hasRelatedSchema(token, entityType);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        return this.schemaCache.constraintsForSchema(descriptor);
    }

    public boolean constraintExists(ConstraintDescriptor descriptor) {
        return this.schemaCache.hasConstraintRule(descriptor);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        return this.schemaCache.constraintsForLabel(labelId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        return this.schemaCache.constraintsForRelationshipType(typeId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        return this.schemaCache.constraints().iterator();
    }

    public IntSet[] constraintsGetPropertyTokensForLogicalKey(int token, EntityType entityType) {
        return this.schemaCache.constraintsGetPropertyTokensForLogicalKey(token, entityType);
    }

    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
        Long constraintId;
        if (index == null) {
            return null;
        }
        OptionalLong owningConstraintId = index.getOwningConstraintId();
        if (owningConstraintId.isPresent() && this.schemaCache.hasConstraintRule(constraintId = Long.valueOf(owningConstraintId.getAsLong()))) {
            return constraintId;
        }
        return null;
    }

    public long countsForNode(int labelId, CursorContext cursorContext) {
        return this.counts.nodeCount(labelId, cursorContext);
    }

    public long estimateCountsForNode(int labelId, CursorContext cursorContext) {
        return this.counts.estimateNodeCount(labelId, cursorContext);
    }

    public void visitAllCounts(CountsVisitor visitor, CursorContext cursorContext) {
        this.counts.accept(visitor, cursorContext);
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId, CursorContext cursorContext) {
        if (startLabelId != -1 && endLabelId != -1) {
            throw new UnsupportedOperationException("not implemented");
        }
        return this.counts.relationshipCount(startLabelId, typeId, endLabelId, cursorContext);
    }

    public long estimateCountsForRelationship(int startLabelId, int typeId, int endLabelId, CursorContext cursorContext) {
        if (startLabelId != -1 && endLabelId != -1) {
            throw new UnsupportedOperationException("not implemented");
        }
        return this.counts.estimateRelationshipCount(startLabelId, typeId, endLabelId, cursorContext);
    }

    public long nodesGetCount(CursorContext cursorContext) {
        if (this.counts != null) {
            try {
                return this.counts.nodeCount(-1, cursorContext);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return this.nodeStore.getIdGenerator().getHighId();
    }

    public long relationshipsGetCount(CursorContext cursorContext) {
        return this.relationshipStore.getIdGenerator().getHighId();
    }

    public int labelCount() {
        return this.tokenHolders.labelTokens().size();
    }

    public int propertyKeyCount() {
        return this.tokenHolders.propertyKeyTokens().size();
    }

    public int relationshipTypeCount() {
        return this.tokenHolders.relationshipTypeTokens().size();
    }

    public boolean nodeExists(long id, StoreCursors storeCursors) {
        return this.nodeStore.isInUse(id, storeCursors.readCursor((CursorType)RecordCursorTypes.NODE_CURSOR));
    }

    public boolean relationshipExists(long id, StoreCursors storeCursors, CursorContext ignored1) {
        return this.relationshipStore.isInUse(id, storeCursors.readCursor((CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR));
    }

    public <T> T getOrCreateSchemaDependantState(Class<T> type, Function<StorageReader, T> factory) {
        return (T)this.schemaCache.getOrCreateDependantState(type, factory, (Object)this);
    }

    public AllNodeScan allNodeScan() {
        return new RecordNodeScan();
    }

    public AllRelationshipsScan allRelationshipScan() {
        return new RecordRelationshipScan();
    }

    public void close() {
        assert (!this.closed);
        this.closed = true;
    }

    public RecordNodeCursor allocateNodeCursor(CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        return new RecordNodeCursor(this.nodeStore, this.relationshipStore, this.relationshipGroupStore, this.groupDegreesStore, cursorContext, storeCursors, memoryTracker);
    }

    public RecordRelationshipTraversalCursor allocateRelationshipTraversalCursor(CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        return new RecordRelationshipTraversalCursor(this.relationshipStore, this.relationshipGroupStore, this.groupDegreesStore, cursorContext, storeCursors, memoryTracker);
    }

    public RecordRelationshipScanCursor allocateRelationshipScanCursor(CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        return new RecordRelationshipScanCursor(this.relationshipStore, cursorContext, storeCursors, memoryTracker);
    }

    public StorageSchemaReader schemaSnapshot() {
        return new StorageSchemaReaderSnapshot(this.schemaCache.snapshot());
    }

    public TokenNameLookup tokenNameLookup() {
        return this.tokenHolders;
    }

    public StoragePropertyCursor allocatePropertyCursor(CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        return new RecordPropertyCursor(this.propertyStore, cursorContext, storeCursors, memoryTracker);
    }
}

