/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.IOUtils;
import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.kernel.impl.store.DynamicAllocatorProvider;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccess;
import org.neo4j.storageengine.util.IdUpdateListener;

public class SchemaRuleMigrationAccessImpl
implements SchemaRuleMigrationAccess {
    private final NeoStores neoStores;
    private final SchemaStorage schemaStorage;
    private final DynamicAllocatorProvider allocationProvider;
    private final CursorContext cursorContext;
    private final MemoryTracker memoryTracker;
    private final StoreCursors storeCursors;

    SchemaRuleMigrationAccessImpl(NeoStores neoStores, SchemaStorage schemaStorage, DynamicAllocatorProvider allocationProvider, CursorContext cursorContext, MemoryTracker memoryTracker, StoreCursors storeCursors) {
        this.neoStores = neoStores;
        this.schemaStorage = schemaStorage;
        this.allocationProvider = allocationProvider;
        this.cursorContext = cursorContext;
        this.memoryTracker = memoryTracker;
        this.storeCursors = storeCursors;
    }

    public Iterable<SchemaRule> getAll() {
        return this.schemaStorage.getAll(this.storeCursors, this.memoryTracker);
    }

    public void writeSchemaRule(SchemaRule rule) throws KernelException {
        this.schemaStorage.writeSchemaRule(rule, IdUpdateListener.DIRECT, this.allocationProvider, this.cursorContext, this.memoryTracker, this.storeCursors);
    }

    public void deleteSchemaRule(long id) throws KernelException {
        this.schemaStorage.deleteSchemaRule(id, IdUpdateListener.DIRECT, this.cursorContext, this.memoryTracker, this.storeCursors);
    }

    public long nextId() {
        return this.schemaStorage.newRuleId(this.cursorContext);
    }

    public void close() throws IOException {
        this.storeCursors.close();
        this.neoStores.flush(DatabaseFlushEvent.NULL, AsyncBlockAccessor.EMPTY_ASYNC_BLOCK_ACCESSOR, this.cursorContext);
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.storeCursors, this.neoStores, this.cursorContext});
    }
}

