/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.RecordStorageCommandHandling;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.storageengine.api.StorageCommand;

public class TransactionAppliersDispatcher
implements Visitor<StorageCommand, IOException>,
AutoCloseable {
    private final TransactionApplier[] appliers;

    TransactionAppliersDispatcher(TransactionApplier ... appliers) {
        this.appliers = appliers;
    }

    @Override
    public void close() throws Exception {
        for (int i = this.appliers.length - 1; i >= 0; --i) {
            this.appliers[i].close();
        }
    }

    public boolean visit(StorageCommand element) throws IOException {
        for (TransactionApplier applier : this.appliers) {
            RecordStorageCommandHandling.handleRecordStorageCommand(element, (ThrowingConsumer<Command, IOException>)((ThrowingConsumer)c -> c.handle(applier)), applier::visitIndexUpdateCommand);
        }
        return false;
    }
}

