/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.validation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.indexcommand.IndexUpdateCommand;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.CommandVisitor;
import org.neo4j.internal.recordstorage.RecordStorageCommandHandling;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.monitoring.TransactionMonitor;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordPageLocationCalculator;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.txstate.validation.TransactionConflictException;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidator;
import org.neo4j.storageengine.api.txstate.validation.ValidationLockDumper;
import org.neo4j.storageengine.util.VersionValidation;

public class TransactionCommandValidator
implements CommandVisitor,
TransactionValidator {
    private final NeoStores neoStores;
    private final Config config;
    private final TransactionMonitor transactionMonitor;
    private final PageCursor[] validationCursors;
    private final MutableLongSet[] checkedPages;
    private LockManager.Client validationLockClient;
    private LockTracer lockTracer;
    private ValidationLockDumper validationLockDumper;
    private CursorContext cursorContext;
    private boolean dumpLocks;
    private boolean failFast;

    public TransactionCommandValidator(NeoStores neoStores, Config config, TransactionMonitor transactionMonitor) {
        this.neoStores = neoStores;
        this.config = config;
        this.validationCursors = new PageCursor[StoreType.STORE_TYPES.length];
        this.checkedPages = new MutableLongSet[StoreType.STORE_TYPES.length];
        this.transactionMonitor = transactionMonitor;
    }

    public void validate(Collection<StorageCommand> commands, CursorContext cursorContext, LockManager.Client validationLockClient, LockTracer lockTracer, ValidationLockDumper lockDumper) {
        try {
            if (commands.isEmpty()) {
                return;
            }
            this.initValidation(cursorContext, lockTracer, validationLockClient, lockDumper);
            cursorContext.getVersionContext().resetObsoleteHeadState();
            RecordStorageCommandHandling.handleRecordStorageCommands(commands, (ThrowingConsumer<Command, IOException>)((ThrowingConsumer)c -> c.handle(this)), ThrowingConsumer.noop());
        }
        catch (TransactionConflictException tce) {
            throw tce;
        }
        catch (Exception e) {
            throw TransactionConflictException.transactionConflict((Exception)e);
        }
        finally {
            this.closeCursors();
        }
    }

    private void initValidation(CursorContext cursorContext, LockTracer lockTracer, LockManager.Client validationLockClient, ValidationLockDumper validationLockDumper) {
        this.cursorContext = cursorContext;
        this.lockTracer = lockTracer;
        this.validationLockDumper = validationLockDumper;
        this.dumpLocks = (Boolean)this.config.get(GraphDatabaseInternalSettings.multi_version_dump_transaction_validation_page_locks);
        this.failFast = (Boolean)this.config.get(GraphDatabaseInternalSettings.multi_version_transaction_validation_fail_fast);
        this.validationLockClient = validationLockClient;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        this.checkStore(((NodeRecord)command.getAfter()).getId(), this.getCursor(StoreType.NODE), StoreType.NODE);
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
        this.checkStore(((RelationshipRecord)command.getAfter()).getId(), this.getCursor(StoreType.RELATIONSHIP), StoreType.RELATIONSHIP);
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        PropertyRecord propertyRecord = (PropertyRecord)command.getAfter();
        this.checkStore(propertyRecord.getId(), this.getCursor(StoreType.PROPERTY), StoreType.PROPERTY);
        if (propertyRecord.inUse()) {
            for (PropertyBlock block : propertyRecord.propertyBlocks()) {
                if (block.isLight() || !block.getValueRecords().get(0).isCreated()) continue;
                this.checkDynamicRecords(block.getValueRecords());
            }
        }
        this.checkDynamicRecords(propertyRecord.getDeletedRecords());
        return false;
    }

    private void checkDynamicRecords(List<DynamicRecord> records) throws IOException {
        PageCursor stringCursor = null;
        PageCursor arrayCursor = null;
        for (DynamicRecord valueRecord : records) {
            PropertyType recordType = valueRecord.getType();
            if (recordType == PropertyType.STRING) {
                if (stringCursor == null) {
                    stringCursor = this.getCursor(StoreType.PROPERTY_STRING);
                }
                this.checkStore(valueRecord.getId(), stringCursor, StoreType.PROPERTY_STRING);
                continue;
            }
            if (recordType == PropertyType.ARRAY) {
                if (arrayCursor == null) {
                    arrayCursor = this.getCursor(StoreType.PROPERTY_ARRAY);
                }
                this.checkStore(valueRecord.getId(), arrayCursor, StoreType.PROPERTY_ARRAY);
                continue;
            }
            throw new InvalidRecordException("Not supported record type for validation: " + String.valueOf(valueRecord));
        }
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
        this.checkStore(((RelationshipGroupRecord)command.getAfter()).getId(), this.getCursor(StoreType.RELATIONSHIP_GROUP), StoreType.RELATIONSHIP_GROUP);
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        this.checkStore(((SchemaRecord)command.getAfter()).getId(), this.getCursor(StoreType.SCHEMA), StoreType.SCHEMA);
        return false;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) {
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) {
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) {
        return false;
    }

    @Override
    public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) {
        return false;
    }

    @Override
    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) {
        return false;
    }

    @Override
    public boolean visitMetaDataCommand(Command.MetaDataCommand command) {
        return false;
    }

    @Override
    public boolean visitGroupDegreeCommand(Command.GroupDegreeCommand command) {
        return false;
    }

    @Override
    public boolean visitIndexUpdateCommand(IndexUpdateCommand<?> command) {
        return false;
    }

    private PageCursor getCursor(StoreType storeType) {
        PageCursor cursor = this.validationCursors[storeType.ordinal()];
        if (cursor != null) {
            return cursor;
        }
        this.validationCursors[storeType.ordinal()] = cursor = this.neoStores.getRecordStore(storeType).openPageCursorForReadingHeadOnly(0L, this.cursorContext);
        return cursor;
    }

    private void closeCursors() {
        Arrays.fill(this.checkedPages, null);
        for (int i = 0; i < this.validationCursors.length; ++i) {
            PageCursor cursor = this.validationCursors[i];
            if (cursor == null) continue;
            cursor.close();
        }
        Arrays.fill(this.validationCursors, null);
    }

    private void checkStore(long recordId, PageCursor pageCursor, StoreType storeType) throws IOException {
        RecordStore store;
        long pageId;
        int position = storeType.ordinal();
        MutableLongSet checkedStorePages = this.checkedPages[position];
        if (checkedStorePages == null) {
            this.checkedPages[position] = checkedStorePages = LongSets.mutable.empty();
        }
        if (checkedStorePages.contains(pageId = RecordPageLocationCalculator.pageIdForRecord(recordId, (store = this.neoStores.getRecordStore(storeType)).getRecordsPerPage()))) {
            return;
        }
        VersionContext versionContext = this.cursorContext.getVersionContext();
        VersionValidation.validatePageVersion((DatabaseFile)storeType.getDatabaseFile(), (long)pageId, (VersionContext)versionContext, (PageCursor)pageCursor, (long)position, (boolean)this.failFast, (ResourceLocker)this.validationLockClient, (TransactionMonitor)this.transactionMonitor, (LockTracer)this.lockTracer);
        checkedStorePages.add(pageId);
        if (this.dumpLocks) {
            this.storePageInfo(storeType, pageId, store.getRecordsPerPage(), versionContext);
        }
    }

    private void storePageInfo(StoreType storeType, long pageId, int unitPerPage, VersionContext versionContext) {
        long chainHead = versionContext.chainHeadVersion();
        this.validationLockDumper.add(pageId, unitPerPage, storeType.name(), chainHead);
    }
}

