/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.validation;

import java.util.Collection;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.ResourceType;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.txstate.validation.ValidationLockDumper;

public class VerboseValidationLogDumper
implements ValidationLockDumper {
    private final Log log;
    private final MutableLongObjectMap<TraceEntry> pageTraces = new LongObjectHashMap();

    public VerboseValidationLogDumper(LogProvider logProvider) {
        this.log = logProvider.getLog(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpLocks(LockManager.Client lockClient, int chunkNumber, long txId) {
        try {
            StringBuilder locksDumpBuilder = new StringBuilder();
            locksDumpBuilder.append("Transaction sequence number: ").append(lockClient.getTransactionId()).append(" with tx id(chunk): ").append(txId).append("(").append(chunkNumber).append(")");
            Collection locks = lockClient.activeLocks();
            if (locks.isEmpty()) {
                locksDumpBuilder.append(" does not have any validation page locks.");
            } else {
                locksDumpBuilder.append(" locked page(s):").append(System.lineSeparator());
                for (ActiveLock activeLock : locks) {
                    if (activeLock.resourceType() != ResourceType.PAGE) continue;
                    long resourceId = activeLock.resourceId();
                    long pageId = resourceId & 0x1FFFFFFFFFFFFL;
                    TraceEntry traceEntry = (TraceEntry)this.pageTraces.get(pageId);
                    if (traceEntry == null) {
                        traceEntry = TraceEntry.UNKNOWN_ENTRY;
                    }
                    locksDumpBuilder.append(pageId).append(" of ").append(traceEntry.storeName()).append(" store, with records per page ").append(traceEntry.recordsPerPage()).append(" observed page version: ").append(traceEntry.headVersion()).append(System.lineSeparator());
                }
            }
            this.log.error(locksDumpBuilder.toString());
        }
        finally {
            this.reset();
        }
    }

    private void reset() {
        this.pageTraces.clear();
    }

    public void add(long pageId, int unitsPerPage, String storeName, long chainHead) {
        this.pageTraces.put(pageId, (Object)new TraceEntry(storeName, unitsPerPage, chainHead));
    }

    private record TraceEntry(String storeName, long recordsPerPage, long headVersion) {
        private static final long UNKNOWN = -1L;
        static final TraceEntry UNKNOWN_ENTRY = new TraceEntry("UNKNOWN", -1L, -1L);
    }
}

