/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdSlotDistribution;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.RecordPageLocationCalculator;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.StoreHeaderFormat;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.util.concurrent.Runnables;

public abstract class CommonAbstractStore<RECORD extends AbstractBaseRecord, HEADER extends StoreHeader>
implements RecordStore<RECORD>,
AutoCloseable {
    protected final Config configuration;
    protected final PageCache pageCache;
    protected final PageCacheTracer pageCacheTracer;
    protected final IdType idType;
    protected final IdGeneratorFactory idGeneratorFactory;
    protected final InternalLog log;
    protected final RecordFormat<RECORD> recordFormat;
    private final FileSystemAbstraction fileSystem;
    final Path storageFile;
    private final Path idFile;
    private final String typeDescriptor;
    protected final boolean readOnly;
    protected PagedFile pagedFile;
    protected int recordSize;
    private int filePageSize;
    private int recordsPerPage;
    private int recordsEndOffset;
    private IdGenerator idGenerator;
    private boolean storeOk = true;
    private RuntimeException causeOfStoreNotOk;
    private final StoreHeaderFormat<HEADER> storeHeaderFormat;
    private HEADER storeHeader;
    private final String databaseName;
    private final ImmutableSet<OpenOption> openOptions;

    public CommonAbstractStore(FileSystemAbstraction fileSystem, Path path, Path idFile, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, PageCacheTracer pageCacheTracer, InternalLogProvider logProvider, String typeDescriptor, RecordFormat<RECORD> recordFormat, StoreHeaderFormat<HEADER> storeHeaderFormat, boolean readOnly, String databaseName, ImmutableSet<OpenOption> openOptions) {
        this.fileSystem = fileSystem;
        this.storageFile = path;
        this.idFile = idFile;
        this.configuration = configuration;
        this.idGeneratorFactory = idGeneratorFactory;
        this.pageCache = pageCache;
        this.idType = idType;
        this.pageCacheTracer = pageCacheTracer;
        this.typeDescriptor = typeDescriptor;
        this.recordFormat = recordFormat;
        this.storeHeaderFormat = storeHeaderFormat;
        this.databaseName = databaseName;
        this.openOptions = openOptions;
        this.readOnly = readOnly;
        this.log = logProvider.getLog(this.getClass());
    }

    protected void initialise(CursorContextFactory contextFactory) {
        try {
            boolean created = this.checkAndLoadStorage(contextFactory);
            if (!created) {
                this.openIdGenerator(contextFactory);
            }
        }
        catch (Exception e) {
            this.closeAndThrow(e);
        }
    }

    private void closeAndThrow(Exception e) {
        this.closeStoreFile();
        Exceptions.throwIfUnchecked((Throwable)e);
        throw new RuntimeException(e);
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor;
    }

    private boolean checkAndLoadStorage(CursorContextFactory contextFactory) {
        CursorContext cursorContext = contextFactory.create("checkAndLoadStorage");
        try {
            if (!this.readOnly && !this.fileSystem.fileExists(this.storageFile)) {
                if (this.createNewStoreFile(contextFactory, cursorContext)) {
                    boolean bl = true;
                    return bl;
                }
            } else if (this.openExistentStore(contextFactory, cursorContext)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to open store file: " + String.valueOf(this.storageFile), (Throwable)e);
        }
        {
            boolean bl = false;
            return bl;
        }
        finally {
            if (cursorContext != null) {
                cursorContext.close();
            }
        }
    }

    private boolean openExistentStore(CursorContextFactory contextFactory, CursorContext cursorContext) throws IOException {
        try {
            this.determineRecordSize(this.storeHeaderFormat.generateHeader());
            if (this.getNumberOfReservedLowIds() > 0) {
                HEADER defaultHeader = this.storeHeaderFormat.generateHeader();
                this.pagedFile = this.pageCache.map(this.storageFile, this.filePageSize, this.databaseName, this.openOptions.newWith((Object)PageCacheOpenOptions.ANY_PAGE_SIZE));
                HEADER readHeader = this.readStoreHeaderAndDetermineRecordSize(this.pagedFile, cursorContext);
                if (!defaultHeader.equals(readHeader)) {
                    this.pagedFile.close();
                    this.pagedFile = null;
                }
            }
            if (this.pagedFile == null) {
                this.pagedFile = this.pageCache.map(this.storageFile, this.filePageSize, this.databaseName, this.openOptions);
            }
            this.determineRecordsPerPage();
        }
        catch (NoSuchFileException | StoreNotFoundException e) {
            if (this.pagedFile != null) {
                this.pagedFile.close();
                this.pagedFile = null;
            }
            if (!this.readOnly) {
                try {
                    if (this.createNewStoreFile(contextFactory, cursorContext)) {
                        return true;
                    }
                }
                catch (IOException e1) {
                    ((Throwable)e).addSuppressed(e1);
                }
            }
            if (e instanceof StoreNotFoundException) {
                throw (StoreNotFoundException)((Object)e);
            }
            throw new StoreNotFoundException("Store file not found: " + String.valueOf(this.storageFile), (Throwable)e);
        }
        return false;
    }

    private boolean createNewStoreFile(CursorContextFactory contextFactory, CursorContext cursorContext) throws IOException {
        this.determineRecordSize(this.storeHeaderFormat.generateHeader());
        this.idGenerator = this.idGeneratorFactory.create(this.pageCache, this.idFile, this.idType, (long)this.getNumberOfReservedLowIds(), false, this.recordFormat.getMaxId(), this.readOnly, this.configuration, contextFactory, this.openOptions, IdSlotDistribution.SINGLE_IDS);
        this.pagedFile = this.pageCache.map(this.storageFile, this.filePageSize, this.databaseName, this.openOptions.newWith((Object)StandardOpenOption.CREATE));
        try (FileFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush();){
            this.initialiseNewStoreFile(flushEvent, AsyncBlockAccessor.EMPTY_ASYNC_BLOCK_ACCESSOR, cursorContext);
        }
        return true;
    }

    protected void initialiseNewStoreFile(FileFlushEvent flushEvent, AsyncBlockAccessor asyncBlockAccessor, CursorContext cursorContext) throws IOException {
        if (this.getNumberOfReservedLowIds() > 0) {
            try (PageCursor pageCursor = this.pagedFile.io(0L, 66, cursorContext);){
                if (pageCursor.next()) {
                    this.storeHeaderFormat.writeHeader(pageCursor);
                    if (pageCursor.checkAndClearBoundsFlag()) {
                        throw new UnderlyingStorageException("Out of page bounds when writing header; page size too small: " + this.pageCache.pageSize() + " bytes.");
                    }
                }
            }
            this.pagedFile.flushAndForce(flushEvent, asyncBlockAccessor);
        }
        this.recordSize = this.determineRecordSize();
        this.determineRecordsPerPage();
    }

    private HEADER readStoreHeaderAndDetermineRecordSize(PagedFile pagedFile, CursorContext cursorContext) throws IOException {
        try (PageCursor pageCursor = pagedFile.io(0L, 1, cursorContext);){
            if (pageCursor.next()) {
                HEADER readHeader;
                do {
                    pageCursor.setOffset(0);
                    readHeader = this.readStoreHeaderAndDetermineRecordSize(pageCursor);
                } while (pageCursor.shouldRetry());
                if (pageCursor.checkAndClearBoundsFlag()) {
                    throw new UnderlyingStorageException("Out of page bounds when reading header; page size too small: " + this.pageCache.pageSize() + " bytes.");
                }
                HEADER HEADER = readHeader;
                return HEADER;
            }
            throw new StoreNotFoundException("Fail to read header record of store file: " + String.valueOf(this.storageFile));
        }
    }

    protected long pageIdForRecord(long id) {
        return RecordPageLocationCalculator.pageIdForRecord(id, this.recordsPerPage);
    }

    protected int offsetForId(long id) {
        return RecordPageLocationCalculator.offsetForId(id, this.recordSize, this.recordsPerPage);
    }

    @Override
    public int getRecordsPerPage() {
        return this.recordsPerPage;
    }

    public long getLastPageId() throws IOException {
        return this.pagedFile.getLastPageId();
    }

    public byte[] getRawRecordData(long id, PageCursor cursor) throws IOException {
        byte[] data = new byte[this.recordSize];
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        if (cursor.next(pageId)) {
            cursor.setOffset(offset);
            cursor.mark();
            do {
                cursor.setOffsetToMark();
                cursor.getBytes(data);
            } while (cursor.shouldRetry());
            this.checkForDecodingErrors(cursor, id, RecordLoad.FORCE);
        }
        return data;
    }

    private HEADER readStoreHeaderAndDetermineRecordSize(PageCursor cursor) {
        HEADER header = this.storeHeaderFormat.readHeader(cursor);
        this.determineRecordSize(header);
        return header;
    }

    private void determineRecordSize(HEADER header) {
        this.storeHeader = header;
        this.recordSize = this.determineRecordSize();
        this.filePageSize = this.recordFormat.getFilePageSize(this.pageCache.pageSize(), this.recordSize);
    }

    private void determineRecordsPerPage() {
        this.recordsPerPage = (this.filePageSize - this.pagedFile.pageReservedBytes()) / this.recordSize;
        this.recordsEndOffset = this.recordsPerPage * this.recordSize;
    }

    public boolean isInUse(long id, PageCursor cursor) {
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        try {
            boolean recordIsInUse = false;
            if (cursor.next(pageId)) {
                cursor.setOffset(offset);
                cursor.mark();
                do {
                    cursor.setOffsetToMark();
                    recordIsInUse = this.isInUse(cursor);
                } while (cursor.shouldRetry());
                this.checkForDecodingErrors(cursor, id, RecordLoad.NORMAL);
            }
            return recordIsInUse;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    @Override
    public PageCursor openPageCursorForReadingWithPrefetching(long id, CursorContext cursorContext) {
        return this.openPageCursorForReading(0L, 8, cursorContext);
    }

    @Override
    public PageCursor openPageCursorForReading(long id, CursorContext cursorContext) {
        return this.openPageCursorForReading(id, 0, cursorContext);
    }

    @Override
    public PageCursor openPageCursorForReadingHeadOnly(long id, CursorContext cursorContext) {
        return this.openPageCursorForReading(id, 128, cursorContext);
    }

    private PageCursor openPageCursorForReading(long id, int additionalCursorFlags, CursorContext cursorContext) {
        try {
            long pageId = this.pageIdForRecord(id);
            return this.pagedFile.io(pageId, 1 | additionalCursorFlags, cursorContext);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    @Override
    public PageCursor openPageCursorForWriting(long id, CursorContext cursorContext) {
        try {
            long pageId = this.pageIdForRecord(id);
            return this.pagedFile.io(pageId, 2, cursorContext);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    private void checkIdScanCursorBounds(PageCursor cursor) {
        if (cursor.checkAndClearBoundsFlag()) {
            throw new UnderlyingStorageException("Out of bounds access on page " + cursor.getCurrentPageId() + " detected while scanning the " + String.valueOf(this.storageFile) + " file for deleted records");
        }
    }

    void setStoreNotOk(RuntimeException cause) {
        this.storeOk = false;
        this.causeOfStoreNotOk = cause;
    }

    void checkStoreOk() {
        if (!this.storeOk) {
            throw this.causeOfStoreNotOk;
        }
    }

    public void setHighId(long highId) {
        this.idGenerator.setHighId(highId);
    }

    public boolean isEmpty() {
        return this.getIdGenerator().getHighId() == (long)this.getNumberOfReservedLowIds();
    }

    void start(CursorContext cursorContext) throws IOException {
        if (!this.storeOk) {
            this.storeOk = true;
            this.causeOfStoreNotOk = null;
        }
        this.idGenerator.start(this.freeIds(cursorContext), cursorContext);
    }

    public FreeIds freeIds(CursorContext cursorContext) {
        return visitor -> {
            try (PageCursor cursor = this.pagedFile.io(0L, 9, cursorContext);){
                int numberOfReservedLowIds;
                int startingId = numberOfReservedLowIds = this.getNumberOfReservedLowIds();
                int recordsPerPage = this.getRecordsPerPage();
                int blockSize = this.getRecordSize();
                long foundHighId = this.scanForHighId(cursorContext);
                long[] foundIds = new long[recordsPerPage];
                boolean done = false;
                while (!done && cursor.next()) {
                    int foundIdsCursor;
                    block6: do {
                        foundIdsCursor = 0;
                        long idPageOffset = cursor.getCurrentPageId() * (long)recordsPerPage;
                        for (int i = startingId; i < recordsPerPage; ++i) {
                            int offset = i * blockSize;
                            cursor.setOffset(offset);
                            long recordId = idPageOffset + (long)i;
                            if (recordId >= foundHighId) {
                                done = true;
                                continue block6;
                            }
                            if (this.isInUse(cursor)) continue;
                            foundIds[foundIdsCursor++] = recordId;
                        }
                    } while (cursor.shouldRetry());
                    startingId = 0;
                    this.checkIdScanCursorBounds(cursor);
                    for (int i = 0; i < foundIdsCursor; ++i) {
                        visitor.accept(foundIds[i]);
                    }
                }
                long l = Long.max(numberOfReservedLowIds, foundHighId) - 1L;
                return l;
            }
        };
    }

    @Override
    public Path getStorageFile() {
        return this.storageFile;
    }

    private void openIdGenerator(CursorContextFactory contextFactory) throws IOException {
        this.idGenerator = this.idGeneratorFactory.open(this.pageCache, this.idFile, this.getIdType(), () -> {
            try (CursorContext cursorContext = contextFactory.create("highIdScan");){
                long l = this.scanForHighId(cursorContext);
                return l;
            }
        }, this.recordFormat.getMaxId(), this.readOnly, this.configuration, contextFactory, this.openOptions, IdSlotDistribution.SINGLE_IDS);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected long scanForHighId(CursorContext cursorContext) {
        try (PageCursor cursor = this.pagedFile.io(0L, 9, cursorContext);){
            int recordsPerPage = this.getRecordsPerPage();
            int recordSize = this.getRecordSize();
            for (long currentId = this.pagedFile.getLastPageId(); currentId >= 0L && cursor.next(currentId); --currentId) {
                boolean found;
                long highestId = 0L;
                do {
                    found = false;
                    long basePageId = cursor.getCurrentPageId() * (long)recordsPerPage;
                    for (int record = 0; record < recordsPerPage; ++record) {
                        cursor.setOffset(record * recordSize);
                        if (!this.isInUse(cursor)) continue;
                        highestId = basePageId + (long)record + 1L;
                        found = true;
                    }
                } while (cursor.shouldRetry());
                this.checkIdScanCursorBounds(cursor);
                if (!found) continue;
                long l = highestId;
                return l;
            }
            long l = this.getNumberOfReservedLowIds();
            return l;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to find high id by scanning backwards " + String.valueOf(this.getStorageFile()), (Throwable)e);
        }
    }

    protected int determineRecordSize() {
        return this.recordFormat.getRecordSize((StoreHeader)this.storeHeader);
    }

    @Override
    public final int getRecordSize() {
        return this.recordSize;
    }

    public long getStoreSize() throws IOException {
        return this.pagedFile.fileSize();
    }

    @Override
    public int getRecordDataSize() {
        return this.recordSize - this.recordFormat.getRecordHeaderSize();
    }

    private boolean isInUse(PageCursor cursor) {
        return this.recordFormat.isInUse(cursor);
    }

    @Override
    public void flush(FileFlushEvent flushEvent, AsyncBlockAccessor asyncBlockAccessor, CursorContext cursorContext) {
        try {
            this.pagedFile.flushAndForce(flushEvent, asyncBlockAccessor);
            this.idGenerator.checkpoint(flushEvent, asyncBlockAccessor, cursorContext);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to flush", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.closeStoreFile();
        }
        catch (IllegalStateException e) {
            throw new UnderlyingStorageException("Failed to close store file: " + String.valueOf(this.getStorageFile()), (Throwable)e);
        }
    }

    private void closeStoreFile() {
        Runnables.runAll((String)"Failure closing store and/or id generator", (Runnable[])new Runnable[]{() -> {
            if (this.pagedFile != null) {
                this.pagedFile.close();
                this.pagedFile = null;
            }
        }, () -> {
            if (this.idGenerator != null) {
                this.idGenerator.close();
                this.idGenerator = null;
            }
        }});
    }

    @Override
    public long getHighestPossibleIdInUse(CursorContext cursorContext) {
        return this.idGenerator != null ? this.idGenerator.getHighestPossibleIdInUse() : this.scanForHighId(cursorContext) - 1L;
    }

    @Override
    public int getNumberOfReservedLowIds() {
        return this.storeHeaderFormat.numberOfReservedRecords();
    }

    public IdType getIdType() {
        return this.idType;
    }

    void logIdUsage(DiagnosticsLogger logger, CursorContext cursorContext) {
        logger.log(String.format("%s[%s]: used=%s high=%s", this.getTypeDescriptor(), this.getStorageFile().getFileName(), this.getIdGenerator().getHighId(), this.getHighestPossibleIdInUse(cursorContext)));
    }

    @Override
    public RECORD newRecord() {
        return this.recordFormat.newRecord();
    }

    @Override
    public RECORD getRecordByCursor(long id, RECORD record, RecordLoad mode, PageCursor cursor, MemoryTracker memoryTracker) throws UnderlyingStorageException {
        try {
            this.readIntoRecord(id, record, mode, cursor, memoryTracker);
            return record;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    private void readIntoRecord(long id, RECORD record, RecordLoad mode, PageCursor cursor, MemoryTracker memoryTracker) throws IOException {
        ((AbstractBaseRecord)record).setId(id);
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        if (cursor.next(pageId)) {
            cursor.setOffset(offset);
            this.readRecordFromPage(id, record, mode, cursor, memoryTracker);
        } else {
            this.verifyAfterNotRead(record, mode);
        }
    }

    @Override
    public void nextRecordByCursor(RECORD record, RecordLoad mode, PageCursor cursor, MemoryTracker memoryTracker) throws UnderlyingStorageException {
        if (cursor.getCurrentPageId() < -1L) {
            throw new IllegalArgumentException("Pages are assumed to be positive or -1 if not initialized");
        }
        try {
            long id = ((AbstractBaseRecord)record).getId() + 1L;
            ((AbstractBaseRecord)record).setId(id);
            long pageId = cursor.getCurrentPageId();
            if (!(cursor.getOffset() < this.recordsEndOffset && pageId >= 0L || cursor.next())) {
                this.verifyAfterNotRead(record, mode);
                return;
            }
            this.readRecordFromPage(id, record, mode, cursor, memoryTracker);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    private void readRecordFromPage(long id, RECORD record, RecordLoad mode, PageCursor cursor, MemoryTracker memoryTracker) throws IOException {
        cursor.mark();
        do {
            this.prepareForReading(cursor, record);
            this.recordFormat.read(record, cursor, mode, this.recordSize, this.recordsPerPage, memoryTracker);
        } while (cursor.shouldRetry());
        this.checkForDecodingErrors(cursor, id, mode);
        this.verifyAfterReading(record, mode);
    }

    @Override
    public void updateRecord(RECORD record, IdUpdateListener idUpdateListener, PageCursor cursor, CursorContext cursorContext, StoreCursors storeCursors) {
        long id = ((AbstractBaseRecord)record).getId();
        IdValidator.assertValidId((IdType)this.getIdType(), (long)id, (long)this.recordFormat.getMaxId());
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        try {
            if (cursor.next(pageId)) {
                cursor.setOffset(offset);
                this.recordFormat.write(record, cursor, this.recordSize, this.recordsPerPage);
                this.checkForDecodingErrors(cursor, id, RecordLoad.NORMAL);
                if (!((AbstractBaseRecord)record).inUse()) {
                    idUpdateListener.markIdAsUnused(this.idGenerator, id, 1, cursorContext);
                } else if (((AbstractBaseRecord)record).isCreated()) {
                    idUpdateListener.markIdAsUsed(this.idGenerator, id, 1, cursorContext);
                }
                if (!(((AbstractBaseRecord)record).inUse() && ((AbstractBaseRecord)record).requiresSecondaryUnit() || !((AbstractBaseRecord)record).hasSecondaryUnitId())) {
                    idUpdateListener.markIdAsUnused(this.idGenerator, ((AbstractBaseRecord)record).getSecondaryUnitId(), 1, cursorContext);
                }
                if (((AbstractBaseRecord)record).inUse() && ((AbstractBaseRecord)record).isSecondaryUnitCreated()) {
                    idUpdateListener.markIdAsUsed(this.idGenerator, ((AbstractBaseRecord)record).getSecondaryUnitId(), 1, cursorContext);
                }
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    @Override
    public void prepareForCommit(RECORD record, IdSequence idSequence, CursorContext cursorContext) {
        if (((AbstractBaseRecord)record).inUse()) {
            this.recordFormat.prepare(record, this.recordSize, idSequence, cursorContext);
        }
    }

    @Override
    public <EXCEPTION extends Exception> void scanAllRecords(Visitor<RECORD, EXCEPTION> visitor, PageCursor pageCursor, MemoryTracker memoryTracker) throws EXCEPTION {
        RECORD record = this.newRecord();
        long highId = this.getIdGenerator().getHighId();
        for (long id = (long)this.getNumberOfReservedLowIds(); id < highId; ++id) {
            this.getRecordByCursor(id, record, RecordLoad.LENIENT_CHECK, pageCursor, memoryTracker);
            if (!((AbstractBaseRecord)record).inUse()) continue;
            visitor.visit(record);
        }
    }

    private void verifyAfterNotRead(RECORD record, RecordLoad mode) {
        ((AbstractBaseRecord)record).clear();
        mode.verify((AbstractBaseRecord)record);
    }

    final void checkForDecodingErrors(PageCursor cursor, long recordId, RecordLoad mode) {
        if (mode.checkForOutOfBounds(cursor)) {
            this.throwOutOfBoundsException(recordId);
        }
        mode.clearOrThrowCursorError(cursor);
    }

    private void throwOutOfBoundsException(long recordId) {
        RECORD record = this.newRecord();
        ((AbstractBaseRecord)record).setId(recordId);
        long pageId = this.pageIdForRecord(recordId);
        int offset = this.offsetForId(recordId);
        throw new UnderlyingStorageException(CommonAbstractStore.buildOutOfBoundsExceptionMessage(record, pageId, offset, this.recordSize, this.pagedFile.pageSize(), this.storageFile.toAbsolutePath().toString()));
    }

    static String buildOutOfBoundsExceptionMessage(AbstractBaseRecord record, long pageId, int offset, int recordSize, int pagePayload, String filename) {
        return "Access to record " + String.valueOf(record) + " went out of bounds of the page. The record size is " + recordSize + " bytes, and the access was at offset " + offset + " bytes into page " + pageId + ", and the pages have a capacity of " + pagePayload + " bytes. The mapped store file in question is " + filename;
    }

    private void verifyAfterReading(RECORD record, RecordLoad mode) {
        if (!mode.verify((AbstractBaseRecord)record)) {
            ((AbstractBaseRecord)record).clear();
        }
    }

    private void prepareForReading(PageCursor cursor, RECORD record) {
        ((AbstractBaseRecord)record).setInUse(false);
        cursor.setOffsetToMark();
    }

    @Override
    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    @Override
    public void ensureHeavy(RECORD record, StoreCursors storeCursors, MemoryTracker memoryTracker) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getStoreHeaderInt() {
        return ((IntStoreHeader)this.storeHeader).value();
    }

    @Override
    public void allocate(long highId) throws IOException {
        this.pagedFile.preAllocate(this.pageIdForRecord(highId));
    }

    @Override
    public long estimateAvailableReservedSpace() {
        return this.idGenerator.getUnusedIdCount() * (long)this.recordSize;
    }

    public Config getConfiguration() {
        return this.configuration;
    }
}

