/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.neo4j.batchimport.api.input.PropertySizeCalculator;
import org.neo4j.internal.id.BatchingIdSequence;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StandardDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.Value;

public class PropertyValueRecordSizeCalculator
implements PropertySizeCalculator {
    private final BatchingIdSequence stringRecordIds = new BatchingIdSequence();
    private final DynamicRecordAllocator stringRecordCounter;
    private final BatchingIdSequence arrayRecordIds = new BatchingIdSequence();
    private final DynamicRecordAllocator arrayRecordCounter;
    private final String storeFormat;
    private final long propertyRecordSize;
    private final long stringRecordSize;
    private final long arrayRecordSize;

    public PropertyValueRecordSizeCalculator(PropertyStore propertyStore) {
        this(propertyStore.getRecordSize(), propertyStore.getStringStore().getRecordSize(), propertyStore.getStringStore().getRecordDataSize(), propertyStore.getArrayStore().getRecordSize(), propertyStore.getArrayStore().getRecordDataSize(), propertyStore.getRecordFormats().name());
    }

    public PropertyValueRecordSizeCalculator(int propertyRecordSize, int stringRecordSize, int stringRecordDataSize, int arrayRecordSize, int arrayRecordDataSize, String storeFormat) {
        this.propertyRecordSize = propertyRecordSize;
        this.stringRecordSize = stringRecordSize;
        this.arrayRecordSize = arrayRecordSize;
        this.stringRecordCounter = new StandardDynamicRecordAllocator((IdSequence)this.stringRecordIds, stringRecordDataSize);
        this.arrayRecordCounter = new StandardDynamicRecordAllocator((IdSequence)this.arrayRecordIds, arrayRecordDataSize);
        this.storeFormat = storeFormat;
    }

    public long calculateSize(Value[] values, CursorContext cursorContext, MemoryTracker memoryTracker) {
        this.stringRecordIds.reset();
        this.arrayRecordIds.reset();
        long propertyRecordsUsed = 0L;
        long freeBlocksInCurrentRecord = 0L;
        for (Value value : values) {
            PropertyBlock block = new PropertyBlock();
            PropertyStore.encodeValue(block, 0, value, this.stringRecordCounter, this.arrayRecordCounter, cursorContext, memoryTracker, this.storeFormat);
            if ((long)block.getValueBlocks().length > freeBlocksInCurrentRecord) {
                ++propertyRecordsUsed;
                freeBlocksInCurrentRecord = PropertyType.getPayloadSizeLongs();
            }
            freeBlocksInCurrentRecord -= (long)block.getValueBlocks().length;
        }
        long size = propertyRecordsUsed * this.propertyRecordSize;
        size += this.stringRecordIds.peek() * this.stringRecordSize;
        return size += this.arrayRecordIds.peek() * this.arrayRecordSize;
    }
}

