/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.OpenOption;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.PageCacheOptionsSelector;
import org.neo4j.kernel.impl.store.format.RecordFormatPropertyConfigurator;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.storageengine.StoreIdGenerator;

public class StoreFactory {
    private final RecordDatabaseLayout databaseLayout;
    private final Config config;
    private final IdGeneratorFactory idGeneratorFactory;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final InternalLogProvider logProvider;
    private final PageCache pageCache;
    private final PageCacheTracer pageCacheTracer;
    private final RecordFormats recordFormats;
    private final CursorContextFactory contextFactory;
    private final boolean readOnly;
    private final StoreIdGenerator storeIdGenerator;
    private final ImmutableSet<OpenOption> openOptions;

    public StoreFactory(DatabaseLayout directoryStructure, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, PageCacheTracer pageCacheTracer, FileSystemAbstraction fileSystemAbstraction, InternalLogProvider logProvider, CursorContextFactory contextFactory, boolean readOnly, StoreIdGenerator storeIdGenerator) {
        this(directoryStructure, config, idGeneratorFactory, pageCache, pageCacheTracer, fileSystemAbstraction, RecordFormatSelector.selectForStoreOrConfigForNewDbs(config, RecordDatabaseLayout.convert((DatabaseLayout)directoryStructure), fileSystemAbstraction, pageCache, logProvider, contextFactory), logProvider, contextFactory, readOnly, storeIdGenerator);
    }

    public StoreFactory(DatabaseLayout databaseLayout, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, PageCacheTracer pageCacheTracer, FileSystemAbstraction fileSystemAbstraction, RecordFormats recordFormats, InternalLogProvider logProvider, CursorContextFactory contextFactory, boolean readOnly, StoreIdGenerator storeIdGenerator) {
        this.databaseLayout = RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout);
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.recordFormats = recordFormats;
        this.contextFactory = contextFactory;
        this.readOnly = readOnly;
        this.storeIdGenerator = storeIdGenerator;
        this.openOptions = StoreFactory.buildOpenOptions(config, recordFormats, (ImmutableSet<OpenOption>)Sets.immutable.empty());
        this.logProvider = logProvider;
        this.pageCache = pageCache;
        this.pageCacheTracer = pageCacheTracer;
        RecordFormatPropertyConfigurator.configureRecordFormat(recordFormats, config);
    }

    public NeoStores openAllNeoStores() {
        return this.openNeoStores(StoreType.STORE_TYPES);
    }

    public NeoStores openNeoStores(StoreType ... storeTypes) {
        if (!this.readOnly) {
            try {
                this.fileSystemAbstraction.mkdirs(this.databaseLayout.databaseDirectory());
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Could not create database directory: " + String.valueOf(this.databaseLayout.databaseDirectory()), (Throwable)e);
            }
        }
        return new NeoStores(this.fileSystemAbstraction, this.databaseLayout, this.config, this.idGeneratorFactory, this.pageCache, this.pageCacheTracer, this.logProvider, this.recordFormats, this.contextFactory, this.readOnly, storeTypes, this.openOptions, this.storeIdGenerator);
    }

    private static ImmutableSet<OpenOption> buildOpenOptions(Config config, RecordFormats recordFormats, ImmutableSet<OpenOption> openOptions) {
        openOptions = openOptions.newWithAll(PageCacheOptionsSelector.select(recordFormats));
        if (!recordFormats.getFormatFamily().equals(FormatFamily.ALIGNED)) {
            return openOptions;
        }
        if (!((Boolean)config.get(GraphDatabaseSettings.pagecache_direct_io)).booleanValue()) {
            return openOptions;
        }
        if (!UnsafeUtil.unsafeByteBufferAccessAvailable()) {
            return openOptions;
        }
        if (openOptions.contains((Object)PageCacheOpenOptions.DIRECT)) {
            return openOptions;
        }
        return openOptions.newWith((Object)PageCacheOpenOptions.DIRECT);
    }
}

