/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.StoreVersion;
import org.neo4j.kernel.impl.store.format.standard.MetaDataRecordFormat;
import org.neo4j.kernel.impl.store.format.standard.NoRecordFormat;
import org.neo4j.kernel.impl.store.format.standard.StandardFormatSettings;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.storageengine.api.StoreFormatLimits;
import org.neo4j.storageengine.api.format.Capability;
import org.neo4j.storageengine.api.format.CapabilityType;

public abstract class BaseRecordFormats
implements RecordFormats {
    private final int majorFormatVersion;
    private final int minorFormatVersion;
    private final boolean onlyForMigration;
    private final Capability[] capabilities;
    private final String introductionVersion;

    protected BaseRecordFormats(StoreVersion storeVersion, Capability ... capabilities) {
        this.onlyForMigration = storeVersion.onlyForMigration();
        this.majorFormatVersion = storeVersion.majorVersion();
        this.minorFormatVersion = storeVersion.minorVersion();
        this.capabilities = capabilities;
        this.introductionVersion = storeVersion.introductionVersion();
    }

    @Override
    public String introductionVersion() {
        return this.introductionVersion;
    }

    @Override
    public int majorVersion() {
        return this.majorFormatVersion;
    }

    @Override
    public int minorVersion() {
        return this.minorFormatVersion;
    }

    @Override
    public RecordFormat<MetaDataRecord> metaData() {
        return new MetaDataRecordFormat();
    }

    @Override
    public boolean onlyForMigration() {
        return this.onlyForMigration;
    }

    public String toString() {
        return String.format("RecordFormat:%s[%s-%d.%d]", this.getClass().getSimpleName(), this.getFormatFamily().name(), this.majorVersion(), this.minorVersion());
    }

    @Override
    public Capability[] capabilities() {
        return this.capabilities;
    }

    @Override
    public boolean hasCapability(Capability capability) {
        return ArrayUtil.contains((Object[])this.capabilities(), (Object)capability);
    }

    public static boolean hasCompatibleCapabilities(RecordFormats one, RecordFormats other, CapabilityType type) {
        Set otherFormatCapabilities;
        Set myFormatCapabilities = Stream.of(one.capabilities()).filter(capability -> capability.isType(type)).collect(Collectors.toSet());
        if (myFormatCapabilities.equals(otherFormatCapabilities = Stream.of(other.capabilities()).filter(capability -> capability.isType(type)).collect(Collectors.toSet()))) {
            return true;
        }
        boolean capabilitiesNotRemoved = otherFormatCapabilities.containsAll(myFormatCapabilities);
        otherFormatCapabilities.removeAll(myFormatCapabilities);
        boolean allAddedAreAdditive = otherFormatCapabilities.stream().allMatch(Capability::isAdditive);
        return capabilitiesNotRemoved && allAddedAreAdditive;
    }

    @Override
    public boolean hasCompatibleCapabilities(RecordFormats other, CapabilityType type) {
        return BaseRecordFormats.hasCompatibleCapabilities(this, other, type);
    }

    @Override
    public RecordFormat<SchemaRecord> schema() {
        return new NoRecordFormat<SchemaRecord>();
    }

    @Override
    public StoreFormatLimits idLimits() {
        return StandardFormatSettings.LIMITS;
    }
}

