/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.Objects;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.string.Mask;

public class RelationshipGroupRecord
extends AbstractBaseRecord {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipGroupRecord.class);
    private int type;
    private long next;
    private long firstOut;
    private long firstIn;
    private long firstLoop;
    private long owningNode;
    private boolean externalDegreesOut;
    private boolean externalDegreesIn;
    private boolean externalDegreesLoop;
    private long prev;

    public RelationshipGroupRecord(long id) {
        super(id);
    }

    public RelationshipGroupRecord(RelationshipGroupRecord other) {
        super(other);
        this.type = other.type;
        this.next = other.next;
        this.firstOut = other.firstOut;
        this.firstIn = other.firstIn;
        this.firstLoop = other.firstLoop;
        this.owningNode = other.owningNode;
        this.prev = other.prev;
        this.externalDegreesOut = other.externalDegreesOut;
        this.externalDegreesIn = other.externalDegreesIn;
        this.externalDegreesLoop = other.externalDegreesLoop;
    }

    public RelationshipGroupRecord initialize(boolean inUse, int type, long firstOut, long firstIn, long firstLoop, long owningNode, long next) {
        super.initialize(inUse);
        this.type = type;
        this.firstOut = firstOut;
        this.firstIn = firstIn;
        this.firstLoop = firstLoop;
        this.owningNode = owningNode;
        this.next = next;
        this.prev = Record.NULL_REFERENCE.intValue();
        this.externalDegreesOut = false;
        this.externalDegreesIn = false;
        this.externalDegreesLoop = false;
        return this;
    }

    @Override
    public void clear() {
        this.initialize(false, Record.NULL_REFERENCE.intValue(), Record.NULL_REFERENCE.intValue(), Record.NULL_REFERENCE.intValue(), Record.NULL_REFERENCE.intValue(), Record.NULL_REFERENCE.intValue(), Record.NULL_REFERENCE.intValue());
        this.prev = Record.NULL_REFERENCE.intValue();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getFirstOut() {
        return this.firstOut;
    }

    public void setFirstOut(long firstOut) {
        this.firstOut = firstOut;
    }

    public long getFirstIn() {
        return this.firstIn;
    }

    public void setFirstIn(long firstIn) {
        this.firstIn = firstIn;
    }

    public long getFirstLoop() {
        return this.firstLoop;
    }

    public void setFirstLoop(long firstLoop) {
        this.firstLoop = firstLoop;
    }

    public long getNext() {
        return this.next;
    }

    public void setNext(long next) {
        this.next = next;
    }

    public void setPrev(long prev) {
        this.prev = prev;
    }

    public long getPrev() {
        return this.prev;
    }

    public long getOwningNode() {
        return this.owningNode;
    }

    public void setOwningNode(long owningNode) {
        this.owningNode = owningNode;
    }

    public boolean hasExternalDegreesOut() {
        return this.externalDegreesOut;
    }

    public void setHasExternalDegreesOut(boolean externalDegrees) {
        this.externalDegreesOut = externalDegrees;
    }

    public boolean hasExternalDegreesIn() {
        return this.externalDegreesIn;
    }

    public void setHasExternalDegreesIn(boolean externalDegrees) {
        this.externalDegreesIn = externalDegrees;
    }

    public boolean hasExternalDegreesLoop() {
        return this.externalDegreesLoop;
    }

    public void setHasExternalDegreesLoop(boolean externalDegrees) {
        this.externalDegreesLoop = externalDegrees;
    }

    public String toString(Mask mask) {
        return "RelationshipGroup[" + this.getId() + ",type=" + this.type + ",out=" + this.firstOut + ",in=" + this.firstIn + ",loop=" + this.firstLoop + ",prev=" + this.prev + ",next=" + this.next + ",used=" + this.inUse() + ",owner=" + this.getOwningNode() + ",externalDegrees=[out:" + this.externalDegreesOut + ",in:" + this.externalDegreesIn + ",loop:" + this.externalDegreesLoop + "]" + this.secondaryUnitToString() + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RelationshipGroupRecord that = (RelationshipGroupRecord)o;
        return this.type == that.type && this.next == that.next && this.firstOut == that.firstOut && this.firstIn == that.firstIn && this.firstLoop == that.firstLoop && this.owningNode == that.owningNode && this.externalDegreesOut == that.externalDegreesOut && this.externalDegreesIn == that.externalDegreesIn && this.externalDegreesLoop == that.externalDegreesLoop;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.type, this.next, this.firstOut, this.firstIn, this.firstLoop, this.owningNode, this.prev, this.externalDegreesOut, this.externalDegreesIn, this.externalDegreesLoop);
    }
}

