/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.Objects;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.string.Mask;

public class RelationshipRecord
extends PrimitiveRecord {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipRecord.class);
    private static final long NO_FIRST_REL_ID = 1L;
    private long firstNode = -1L;
    private long secondNode = -1L;
    private int type = -1;
    private long firstPrevRel = 1L;
    private long firstNextRel = Record.NO_NEXT_RELATIONSHIP.intValue();
    private long secondPrevRel = 1L;
    private long secondNextRel = Record.NO_NEXT_RELATIONSHIP.intValue();
    private boolean firstInFirstChain = true;
    private boolean firstInSecondChain = true;

    public RelationshipRecord(long id) {
        super(id);
    }

    public RelationshipRecord(RelationshipRecord other) {
        super(other);
        this.firstNode = other.firstNode;
        this.secondNode = other.secondNode;
        this.type = other.type;
        this.firstPrevRel = other.firstPrevRel;
        this.firstNextRel = other.firstNextRel;
        this.secondPrevRel = other.secondPrevRel;
        this.secondNextRel = other.secondNextRel;
        this.firstInFirstChain = other.firstInFirstChain;
        this.firstInSecondChain = other.firstInSecondChain;
    }

    public RelationshipRecord initialize(boolean inUse, long nextProp, long firstNode, long secondNode, int type, long firstPrevRel, long firstNextRel, long secondPrevRel, long secondNextRel, boolean firstInFirstChain, boolean firstInSecondChain) {
        super.initialize(inUse, nextProp);
        this.firstNode = firstNode;
        this.secondNode = secondNode;
        this.type = type;
        this.firstPrevRel = firstPrevRel;
        this.firstNextRel = firstNextRel;
        this.secondPrevRel = secondPrevRel;
        this.secondNextRel = secondNextRel;
        this.firstInFirstChain = firstInFirstChain;
        this.firstInSecondChain = firstInSecondChain;
        return this;
    }

    @Override
    public void clear() {
        this.initialize(false, Record.NO_NEXT_PROPERTY.intValue(), -1L, -1L, -1, 1L, Record.NO_NEXT_RELATIONSHIP.intValue(), 1L, Record.NO_NEXT_RELATIONSHIP.intValue(), true, true);
    }

    public void setLinks(long firstNode, long secondNode, int type) {
        this.firstNode = firstNode;
        this.secondNode = secondNode;
        this.type = type;
    }

    public long getFirstNode() {
        return this.firstNode;
    }

    public void setFirstNode(long firstNode) {
        this.firstNode = firstNode;
    }

    public long getSecondNode() {
        return this.secondNode;
    }

    public void setSecondNode(long secondNode) {
        this.secondNode = secondNode;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getFirstPrevRel() {
        return this.firstPrevRel;
    }

    public long getPrevRel(long nodeId) {
        this.assertEitherFirstOrSecondNode(nodeId);
        return nodeId == this.firstNode ? this.firstPrevRel : this.secondPrevRel;
    }

    public long getNextRel(long nodeId) {
        this.assertEitherFirstOrSecondNode(nodeId);
        return nodeId == this.firstNode ? this.firstNextRel : this.secondNextRel;
    }

    public void setFirstPrevRel(long firstPrevRel) {
        this.firstPrevRel = firstPrevRel;
    }

    public void setPrevRel(long prevRel, long nodeId) {
        this.assertEitherFirstOrSecondNode(nodeId);
        if (nodeId == this.firstNode) {
            this.firstPrevRel = prevRel;
        }
        if (nodeId == this.secondNode) {
            this.secondPrevRel = prevRel;
        }
    }

    private void assertEitherFirstOrSecondNode(long nodeId) {
        boolean firstOrSecond;
        boolean bl = firstOrSecond = nodeId == this.firstNode || nodeId == this.secondNode;
        if (!firstOrSecond) {
            throw new IllegalArgumentException(nodeId + " is neither first nor second node of " + String.valueOf(this));
        }
    }

    public void setNextRel(long nextRel, long nodeId) {
        this.assertEitherFirstOrSecondNode(nodeId);
        if (nodeId == this.firstNode) {
            this.firstNextRel = nextRel;
        }
        if (nodeId == this.secondNode) {
            this.secondNextRel = nextRel;
        }
    }

    public long getFirstNextRel() {
        return this.firstNextRel;
    }

    public void setFirstNextRel(long firstNextRel) {
        this.firstNextRel = firstNextRel;
    }

    public long getSecondPrevRel() {
        return this.secondPrevRel;
    }

    public void setSecondPrevRel(long secondPrevRel) {
        this.secondPrevRel = secondPrevRel;
    }

    public long getSecondNextRel() {
        return this.secondNextRel;
    }

    public void setSecondNextRel(long secondNextRel) {
        this.secondNextRel = secondNextRel;
    }

    public boolean isFirstInFirstChain() {
        return this.firstInFirstChain;
    }

    public void setFirstInFirstChain(boolean firstInFirstChain) {
        this.firstInFirstChain = firstInFirstChain;
    }

    public void setFirstInChain(boolean first, long nodeId) {
        this.assertEitherFirstOrSecondNode(nodeId);
        if (nodeId == this.firstNode) {
            this.firstInFirstChain = first;
        }
        if (nodeId == this.secondNode) {
            this.firstInSecondChain = first;
        }
    }

    public boolean isFirstInChain(long nodeId) {
        this.assertEitherFirstOrSecondNode(nodeId);
        return nodeId == this.firstNode ? this.firstInFirstChain : this.firstInSecondChain;
    }

    public boolean isFirstInSecondChain() {
        return this.firstInSecondChain;
    }

    public void setFirstInSecondChain(boolean firstInSecondChain) {
        this.firstInSecondChain = firstInSecondChain;
    }

    public String toString(Mask mask) {
        return "Relationship[" + this.getId() + ",used=" + this.inUse() + ",source=" + this.firstNode + ",target=" + this.secondNode + ",type=" + this.type + (this.firstInFirstChain ? ",sCount=" : ",sPrev=") + this.firstPrevRel + ",sNext=" + this.firstNextRel + (this.firstInSecondChain ? ",tCount=" : ",tPrev=") + this.secondPrevRel + ",tNext=" + this.secondNextRel + ",prop=" + this.getNextProp() + this.secondaryUnitToString() + (this.firstInFirstChain ? ", sFirst" : ",!sFirst") + (this.firstInSecondChain ? ", tFirst" : ",!tFirst") + "]";
    }

    @Override
    public void setIdTo(PropertyRecord property) {
        property.setRelId(this.getId());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RelationshipRecord that = (RelationshipRecord)o;
        return this.firstNode == that.firstNode && this.secondNode == that.secondNode && this.type == that.type && this.firstPrevRel == that.firstPrevRel && this.firstNextRel == that.firstNextRel && this.secondPrevRel == that.secondPrevRel && this.secondNextRel == that.secondNextRel && this.firstInFirstChain == that.firstInFirstChain && this.firstInSecondChain == that.firstInSecondChain;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.firstNode, this.secondNode, this.type, this.firstPrevRel, this.firstNextRel, this.secondPrevRel, this.secondNextRel, this.firstInFirstChain, this.firstInSecondChain);
    }
}

