/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.batchimport.api.AdditionalInitialIds;
import org.neo4j.batchimport.api.BatchImporter;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.IndexImporterFactory;
import org.neo4j.batchimport.api.InputIterable;
import org.neo4j.batchimport.api.InputIterator;
import org.neo4j.batchimport.api.Monitor;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.batchimport.api.input.InputChunk;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.configuration.Config;
import org.neo4j.counts.CountsStore;
import org.neo4j.counts.CountsUpdater;
import org.neo4j.exceptions.KernelException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.batchimport.staging.CoarseBoundedProgressExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.CountsStoreProvider;
import org.neo4j.internal.counts.DegreeStoreProvider;
import org.neo4j.internal.counts.DegreeUpdater;
import org.neo4j.internal.counts.DegreesRebuilder;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.ScanOnOpenOverwritingIdGeneratorFactory;
import org.neo4j.internal.id.ScanOnOpenReadOnlyIdGeneratorFactory;
import org.neo4j.internal.recordstorage.RecordNodeCursor;
import org.neo4j.internal.recordstorage.RecordStorageEngineFactory;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseFile;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.LegacyMetadataHandler;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.format.PageCacheOptionsSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.DirectRecordStoreMigrator;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.RecordStoreVersion;
import org.neo4j.kernel.impl.storemigration.SchemaStoreMigration;
import org.neo4j.kernel.impl.storemigration.StoreMigratorFileOperation;
import org.neo4j.kernel.impl.storemigration.StoreScanAsInputIterator;
import org.neo4j.kernel.impl.storemigration.StoreScanChunk;
import org.neo4j.kernel.impl.transaction.log.EmptyLogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.StoreIdGenerator;
import org.neo4j.storageengine.api.LogFilesInitializer;
import org.neo4j.storageengine.api.SchemaRule44;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.format.Capability;
import org.neo4j.storageengine.api.format.CapabilityType;
import org.neo4j.storageengine.api.format.Index44Compatibility;
import org.neo4j.storageengine.migration.AbstractStoreMigrationParticipant;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccess;
import org.neo4j.token.TokenHolders;

public class RecordStorageMigrator
extends AbstractStoreMigrationParticipant {
    private static final String RECORD_STORAGE_MIGRATION_TAG = "recordStorageMigration";
    private static final String NODE_CHUNK_MIGRATION_TAG = "nodeChunkMigration";
    private static final String RELATIONSHIP_CHUNK_MIGRATION_TAG = "relationshipChunkMigration";
    private final Config config;
    private final LogService logService;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final PageCacheTracer pageCacheTracer;
    private final JobScheduler jobScheduler;
    private final CursorContextFactory contextFactory;
    private final BatchImporterFactory batchImporterFactory;
    private final MemoryTracker memoryTracker;
    private final boolean forceBtreeIndexesToRange;
    private final long maxOffHeapMemory;
    private boolean formatsHaveDifferentStoreCapabilities;

    public RecordStorageMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, PageCacheTracer pageCacheTracer, Config config, LogService logService, JobScheduler jobScheduler, CursorContextFactory contextFactory, BatchImporterFactory batchImporterFactory, MemoryTracker memoryTracker, boolean forceBtreeIndexesToRange, long maxOffHeapMemory) {
        super("store files");
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
        this.logService = logService;
        this.jobScheduler = jobScheduler;
        this.pageCacheTracer = pageCacheTracer;
        this.contextFactory = contextFactory;
        this.batchImporterFactory = batchImporterFactory;
        this.memoryTracker = memoryTracker;
        this.forceBtreeIndexesToRange = forceBtreeIndexesToRange;
        this.maxOffHeapMemory = maxOffHeapMemory;
    }

    public void migrate(DatabaseLayout directoryLayoutArg, DatabaseLayout migrationLayoutArg, ProgressListener progressListener, StoreVersion fromVersion, StoreVersion toVersion, IndexImporterFactory indexImporterFactory, LogTailMetadata tailMetadata) throws IOException, KernelException {
        RecordFormats newFormat;
        RecordDatabaseLayout directoryLayout = RecordDatabaseLayout.convert((DatabaseLayout)directoryLayoutArg);
        RecordDatabaseLayout migrationLayout = RecordDatabaseLayout.convert((DatabaseLayout)migrationLayoutArg);
        RecordFormats oldFormat = ((RecordStoreVersion)fromVersion).getFormat();
        this.formatsHaveDifferentStoreCapabilities = !oldFormat.hasCompatibleCapabilities(newFormat = ((RecordStoreVersion)toVersion).getFormat(), CapabilityType.FORMAT);
        boolean requiresDynamicStoreMigration = this.formatsHaveDifferentStoreCapabilities || !newFormat.dynamic().equals(oldFormat.dynamic());
        boolean requiresPropertyMigration = !newFormat.property().equals(oldFormat.property()) || requiresDynamicStoreMigration;
        try (CursorContext cursorContext = this.contextFactory.create(RECORD_STORAGE_MIGRATION_TAG);){
            block34: {
                SchemaStoreMigration.SchemaStoreMigrator schemaStoreMigration = SchemaStoreMigration.getSchemaStoreMigration(oldFormat, directoryLayout, cursorContext, requiresPropertyMigration, this.forceBtreeIndexesToRange || "system".equals(directoryLayoutArg.getDatabaseName()), this.config, this.pageCache, this.pageCacheTracer, this.fileSystem, this.contextFactory, this.memoryTracker);
                schemaStoreMigration.assertCanMigrate();
                long lastTxId = tailMetadata.getLastCommittedTransaction().id();
                TransactionId lastTxInfo = tailMetadata.getLastCommittedTransaction();
                LogPosition lastTxLogPosition = tailMetadata.getLastTransactionLogPosition();
                long checkpointLogVersion = tailMetadata.getCheckpointLogVersion();
                if (this.formatsHaveDifferentStoreCapabilities) {
                    this.migrateWithBatchImporter(directoryLayout, migrationLayout, lastTxId, lastTxInfo.appendIndex(), lastTxInfo.checksum(), lastTxLogPosition.getLogVersion(), lastTxLogPosition.getByteOffset(), checkpointLogVersion, tailMetadata.getLastCheckpointedAppendIndex(), progressListener, oldFormat, newFormat, requiresDynamicStoreMigration, requiresPropertyMigration, indexImporterFactory);
                }
                if (RecordStorageMigrator.need50Migration(oldFormat)) {
                    schemaStoreMigration.copyFilesInPreparationForMigration(this.fileSystem, directoryLayout, migrationLayout);
                    DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(this.fileSystem, RecoveryCleanupWorkCollector.immediate(), this.pageCacheTracer, migrationLayout.getDatabaseName());
                    StoreFactory dstFactory = this.createStoreFactory(migrationLayout, newFormat, (IdGeneratorFactory)idGeneratorFactory);
                    LegacyMetadataHandler.Metadata44 metadata44 = LegacyMetadataHandler.readMetadata44FromStore(this.pageCache, directoryLayout.metadataStore(), directoryLayout.getDatabaseName(), cursorContext);
                    try (NeoStores dstStore = dstFactory.openNeoStores(StoreType.SCHEMA, StoreType.PROPERTY, StoreType.META_DATA, StoreType.LABEL_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.PROPERTY_KEY_TOKEN);
                         CachedStoreCursors dstCursors = new CachedStoreCursors(dstStore, cursorContext);
                         SchemaRuleMigrationAccess dstAccess = RecordStorageEngineFactory.createMigrationTargetSchemaRuleAccess(dstStore, this.contextFactory, this.memoryTracker);){
                        MetaDataStore metaDataStore = dstStore.getMetaDataStore();
                        metaDataStore.regenerateMetadata(metadata44.storeId(), metadata44.maybeExternalId() != null ? metadata44.maybeExternalId() : UUID.randomUUID(), cursorContext);
                        if (metadata44.maybeDatabaseId() != null) {
                            metaDataStore.setDatabaseIdUuid(metadata44.maybeDatabaseId(), cursorContext);
                        }
                        dstStore.start(cursorContext);
                        TokenHolders dstTokensHolders = RecordStorageMigrator.createTokenHolders(dstStore, dstCursors, this.memoryTracker);
                        schemaStoreMigration.migrate(dstAccess, dstTokensHolders);
                        try (DatabaseFlushEvent databaseFlushEvent = this.pageCacheTracer.beginDatabaseFlush();){
                            dstStore.flush(databaseFlushEvent, AsyncBlockAccessor.EMPTY_ASYNC_BLOCK_ACCESSOR, cursorContext);
                            break block34;
                        }
                    }
                }
                if (requiresPropertyMigration) {
                    schemaStoreMigration.copyFilesInPreparationForMigration(this.fileSystem, directoryLayout, migrationLayout);
                    this.migrateSchemaStore(schemaStoreMigration, migrationLayout, newFormat, cursorContext, this.memoryTracker);
                }
            }
            StoreMigratorFileOperation.fileOperation((FileOperation)FileOperation.COPY, (FileSystemAbstraction)this.fileSystem, (DatabaseLayout)directoryLayout, (DatabaseLayout)migrationLayout, Collections.singleton(RecordDatabaseFile.METADATA_STORE), (boolean)true, (boolean)false, (ExistingTargetStrategy)ExistingTargetStrategy.SKIP);
            MetaDataStore.FieldAccess fieldAccess = MetaDataStore.getFieldAccess(this.pageCache, migrationLayout.metadataStore(), migrationLayout.getDatabaseName(), cursorContext);
            StoreId oldStoreId = fieldAccess.readStoreId();
            long random = oldStoreId.getRandom();
            if (oldFormat.majorVersion() != newFormat.majorVersion() || !oldFormat.getFormatFamily().equals(newFormat.getFormatFamily())) {
                random = new SecureRandom().nextLong();
            }
            StoreId newStoreId = new StoreId(oldStoreId.getCreationTime(), random, "record", newFormat.getFormatFamily().name(), newFormat.majorVersion(), newFormat.minorVersion());
            fieldAccess.writeStoreId(newStoreId);
        }
    }

    private void migrateWithBatchImporter(RecordDatabaseLayout sourceDirectoryStructure, RecordDatabaseLayout migrationDirectoryStructure, long lastTxId, long lastTxAppendIndex, int lastTxChecksum, long lastTxLogVersion, long lastTxLogByteOffset, long lastCheckpointLogVersion, long lastAppendIndex, ProgressListener progressListener, RecordFormats oldFormat, RecordFormats newFormat, boolean requiresDynamicStoreMigration, boolean requiresPropertyMigration, IndexImporterFactory indexImporterFactory) throws IOException {
        this.prepareBatchImportMigration(sourceDirectoryStructure, migrationDirectoryStructure, oldFormat, newFormat);
        try (NeoStores legacyStore = this.instantiateLegacyStore(oldFormat, sourceDirectoryStructure);){
            Configuration.Overridden importConfig = new Configuration.Overridden(Configuration.defaultConfiguration(), this.config){

                public long maxOffHeapMemory() {
                    return RecordStorageMigrator.this.maxOffHeapMemory == -1L ? super.maxOffHeapMemory() : RecordStorageMigrator.this.maxOffHeapMemory;
                }
            };
            AdditionalInitialIds additionalInitialIds = RecordStorageMigrator.readAdditionalIds(lastTxId, lastTxAppendIndex, lastTxChecksum, lastTxLogVersion, lastTxLogByteOffset, lastCheckpointLogVersion, lastAppendIndex);
            BatchImporter importer = this.batchImporterFactory.instantiate((DatabaseLayout)migrationDirectoryStructure, this.fileSystem, this.pageCacheTracer, (Configuration)importConfig, this.logService, RecordStorageMigrator.migrationBatchImporterMonitor(legacyStore, progressListener, (Configuration)importConfig), additionalInitialIds, (LogTailMetadata)new EmptyLogTailMetadata(this.config), this.config, Monitor.NO_MONITOR, this.jobScheduler, Collector.STRICT, LogFilesInitializer.NULL, indexImporterFactory, this.memoryTracker, this.contextFactory);
            InputIterable nodes = () -> RecordStorageMigrator.legacyNodesAsInput(legacyStore, requiresPropertyMigration, this.contextFactory, this.memoryTracker);
            InputIterable relationships = () -> RecordStorageMigrator.legacyRelationshipsAsInput(legacyStore, requiresPropertyMigration, this.contextFactory, this.memoryTracker);
            long propertyStoreSize = RecordStorageMigrator.storeSize(legacyStore.getPropertyStore()) / 2L + RecordStorageMigrator.storeSize(legacyStore.getPropertyStore().getStringStore()) / 2L + RecordStorageMigrator.storeSize(legacyStore.getPropertyStore().getArrayStore()) / 2L;
            PropertyStore legacyPropertyStore = legacyStore.getPropertyStore();
            RelationshipStore legacyRelStore = legacyStore.getRelationshipStore();
            NodeStore legacyNodeStore = legacyStore.getNodeStore();
            Input.Estimates estimates = Input.knownEstimates((long)legacyNodeStore.getIdGenerator().getHighId(), (long)legacyRelStore.getIdGenerator().getHighId(), (long)legacyPropertyStore.getIdGenerator().getHighId(), (long)legacyPropertyStore.getIdGenerator().getHighId(), (long)(propertyStoreSize / 2L), (long)(propertyStoreSize / 2L), (long)0L);
            importer.doImport(Input.input((InputIterable)nodes, (InputIterable)relationships, (IdType)IdType.ACTUAL, (Input.Estimates)estimates, (ReadableGroups)ReadableGroups.EMPTY, (boolean)false));
            ArrayList<RecordDatabaseFile> storesToDeleteFromMigratedDirectory = new ArrayList<RecordDatabaseFile>();
            storesToDeleteFromMigratedDirectory.add(RecordDatabaseFile.METADATA_STORE);
            if (!requiresPropertyMigration) {
                storesToDeleteFromMigratedDirectory.addAll(Arrays.asList(RecordDatabaseFile.PROPERTY_STORE, RecordDatabaseFile.PROPERTY_STRING_STORE, RecordDatabaseFile.PROPERTY_ARRAY_STORE));
            }
            if (!requiresDynamicStoreMigration) {
                storesToDeleteFromMigratedDirectory.addAll(Arrays.asList(RecordDatabaseFile.NODE_LABEL_STORE, RecordDatabaseFile.LABEL_TOKEN_STORE, RecordDatabaseFile.LABEL_TOKEN_NAMES_STORE, RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, RecordDatabaseFile.PROPERTY_KEY_TOKEN_STORE, RecordDatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, RecordDatabaseFile.SCHEMA_STORE));
            }
            StoreMigratorFileOperation.fileOperation((FileOperation)FileOperation.DELETE, (FileSystemAbstraction)this.fileSystem, (DatabaseLayout)migrationDirectoryStructure, (DatabaseLayout)migrationDirectoryStructure, storesToDeleteFromMigratedDirectory, (boolean)true, (boolean)true, null);
        }
    }

    private static long storeSize(CommonAbstractStore<? extends AbstractBaseRecord, ? extends StoreHeader> store) {
        return store.getIdGenerator().getHighId() * (long)store.getRecordSize();
    }

    private NeoStores instantiateLegacyStore(RecordFormats format, RecordDatabaseLayout directoryStructure) {
        StoreType[] storesToOpen = (StoreType[])Arrays.stream(StoreType.STORE_TYPES).filter(storeType -> storeType != StoreType.META_DATA).toArray(StoreType[]::new);
        return new StoreFactory((DatabaseLayout)directoryStructure, this.config, (IdGeneratorFactory)new ScanOnOpenReadOnlyIdGeneratorFactory(), this.pageCache, this.pageCacheTracer, this.fileSystem, format, (InternalLogProvider)NullLogProvider.getInstance(), this.contextFactory, true, StoreIdGenerator.UNIQUE_ID).openNeoStores(storesToOpen);
    }

    private void prepareBatchImportMigration(RecordDatabaseLayout sourceDirectoryStructure, RecordDatabaseLayout migrationStructure, RecordFormats oldFormat, RecordFormats newFormat) throws IOException {
        this.createStore(migrationStructure, newFormat);
        RecordDatabaseFile[] storesFilesToMigrate = new RecordDatabaseFile[]{RecordDatabaseFile.LABEL_TOKEN_STORE, RecordDatabaseFile.LABEL_TOKEN_NAMES_STORE, RecordDatabaseFile.PROPERTY_KEY_TOKEN_STORE, RecordDatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, RecordDatabaseFile.NODE_LABEL_STORE};
        if (oldFormat.hasCompatibleCapabilities(newFormat, CapabilityType.FORMAT) && newFormat.dynamic().equals(oldFormat.dynamic())) {
            StoreMigratorFileOperation.fileOperation((FileOperation)FileOperation.COPY, (FileSystemAbstraction)this.fileSystem, (DatabaseLayout)sourceDirectoryStructure, (DatabaseLayout)migrationStructure, Arrays.asList(storesFilesToMigrate), (boolean)true, (boolean)true, (ExistingTargetStrategy)ExistingTargetStrategy.OVERWRITE);
        } else {
            DirectRecordStoreMigrator migrator = new DirectRecordStoreMigrator(this.pageCache, this.fileSystem, this.config, this.contextFactory, this.pageCacheTracer);
            StoreType[] storesToMigrate = new StoreType[]{StoreType.LABEL_TOKEN, StoreType.LABEL_TOKEN_NAME, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY_KEY_TOKEN_NAME, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN_NAME, StoreType.NODE_LABEL};
            ProgressListener progressListener = ProgressListener.NONE;
            migrator.migrate(sourceDirectoryStructure, oldFormat, migrationStructure, newFormat, progressListener, storesToMigrate, this.memoryTracker, StoreType.NODE);
        }
        this.createStoreFactory(migrationStructure, newFormat, (IdGeneratorFactory)new ScanOnOpenOverwritingIdGeneratorFactory(this.fileSystem, this.pageCacheTracer, migrationStructure.getDatabaseName())).openAllNeoStores().close();
    }

    private void createStore(RecordDatabaseLayout migrationDirectoryStructure, RecordFormats newFormat) {
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(this.fileSystem, RecoveryCleanupWorkCollector.immediate(), this.pageCacheTracer, migrationDirectoryStructure.getDatabaseName());
        this.createStoreFactory(migrationDirectoryStructure, newFormat, (IdGeneratorFactory)idGeneratorFactory).openAllNeoStores().close();
    }

    private StoreFactory createStoreFactory(RecordDatabaseLayout databaseLayout, RecordFormats formats, IdGeneratorFactory idGeneratorFactory) {
        return new StoreFactory((DatabaseLayout)databaseLayout, this.config, idGeneratorFactory, this.pageCache, this.pageCacheTracer, this.fileSystem, formats, (InternalLogProvider)NullLogProvider.getInstance(), this.contextFactory, false, StoreIdGenerator.UNIQUE_ID);
    }

    private static AdditionalInitialIds readAdditionalIds(final long lastTxId, final long lastTxAppendIndex, final int lastTxChecksum, final long lastTxLogVersion, final long lastTxLogByteOffset, final long lastCheckpointLogVersion, final long lastAppendIndex) {
        return new AdditionalInitialIds(){

            public long lastCommittedTransactionId() {
                return lastTxId;
            }

            public int lastCommittedTransactionChecksum() {
                return lastTxChecksum;
            }

            public long lastCommittedTransactionLogVersion() {
                return lastTxLogVersion;
            }

            public long lastCommittedTransactionLogByteOffset() {
                return lastTxLogByteOffset;
            }

            public long checkpointLogVersion() {
                return lastCheckpointLogVersion;
            }

            public long lastAppendIndex() {
                return lastAppendIndex;
            }

            public long lastCommittedTransactionAppendIndex() {
                return lastTxAppendIndex;
            }
        };
    }

    private static ExecutionMonitor migrationBatchImporterMonitor(NeoStores legacyStore, ProgressListener progressListener, Configuration config) {
        RelationshipStore legacyRelStore = legacyStore.getRelationshipStore();
        NodeStore legacyNodeStore = legacyStore.getNodeStore();
        return new BatchImporterProgressMonitor(legacyNodeStore.getIdGenerator().getHighId(), legacyRelStore.getIdGenerator().getHighId(), config, progressListener);
    }

    private static InputIterator legacyRelationshipsAsInput(final NeoStores legacyStore, final boolean requiresPropertyMigration, final CursorContextFactory contextFactory, final MemoryTracker memoryTracker) {
        return new StoreScanAsInputIterator<RelationshipRecord>((RecordStore)legacyStore.getRelationshipStore()){

            public InputChunk newChunk() {
                CursorContext cursorContext = contextFactory.create(RecordStorageMigrator.RELATIONSHIP_CHUNK_MIGRATION_TAG);
                CachedStoreCursors storeCursors = new CachedStoreCursors(legacyStore, cursorContext);
                return new RelationshipRecordChunk(new RecordStorageReader(legacyStore), requiresPropertyMigration, cursorContext, (StoreCursors)storeCursors, memoryTracker);
            }
        };
    }

    private static InputIterator legacyNodesAsInput(final NeoStores legacyStore, final boolean requiresPropertyMigration, final CursorContextFactory contextFactory, final MemoryTracker memoryTracker) {
        return new StoreScanAsInputIterator<NodeRecord>((RecordStore)legacyStore.getNodeStore()){

            public InputChunk newChunk() {
                CursorContext cursorContext = contextFactory.create(RecordStorageMigrator.NODE_CHUNK_MIGRATION_TAG);
                CachedStoreCursors storeCursors = new CachedStoreCursors(legacyStore, cursorContext);
                return new NodeRecordChunk(new RecordStorageReader(legacyStore), requiresPropertyMigration, cursorContext, (StoreCursors)storeCursors, memoryTracker);
            }
        };
    }

    public void moveMigratedFiles(DatabaseLayout migrationLayoutArg, DatabaseLayout directoryLayoutArg, StoreVersion versionToUpgradeFrom, StoreVersion versionToUpgradeTo, MemoryTracker memoryTracker) throws IOException {
        RecordDatabaseLayout directoryLayout = RecordDatabaseLayout.convert((DatabaseLayout)directoryLayoutArg);
        RecordDatabaseLayout migrationLayout = RecordDatabaseLayout.convert((DatabaseLayout)migrationLayoutArg);
        StoreMigratorFileOperation.fileOperation((FileOperation)FileOperation.MOVE, (FileSystemAbstraction)this.fileSystem, (DatabaseLayout)migrationLayout, (DatabaseLayout)directoryLayout, (Iterable)Iterables.iterable((Object[])RecordDatabaseFile.values()), (boolean)true, (boolean)true, (ExistingTargetStrategy)ExistingTargetStrategy.OVERWRITE);
        RecordFormats oldFormat = ((RecordStoreVersion)versionToUpgradeFrom).getFormat();
        if (RecordStorageMigrator.need50Migration(oldFormat)) {
            RecordStorageMigrator.deleteBtreeIndexFiles(this.fileSystem, directoryLayout);
        }
    }

    private void migrateSchemaStore(SchemaStoreMigration.SchemaStoreMigrator schemaStoreMigration, RecordDatabaseLayout migrationLayout, RecordFormats newFormat, CursorContext cursorContext, MemoryTracker memoryTracker) throws IOException, KernelException {
        StoreFactory dstFactory = this.createStoreFactory(migrationLayout, newFormat, (IdGeneratorFactory)new ScanOnOpenOverwritingIdGeneratorFactory(this.fileSystem, this.pageCacheTracer, migrationLayout.getDatabaseName()));
        try (NeoStores dstStore = dstFactory.openNeoStores(StoreType.SCHEMA, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY, StoreType.PROPERTY_KEY_TOKEN_NAME, StoreType.LABEL_TOKEN, StoreType.LABEL_TOKEN_NAME, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN_NAME);
             CachedStoreCursors dstCursors = new CachedStoreCursors(dstStore, cursorContext);){
            dstStore.start(cursorContext);
            TokenHolders dstTokensHolders = RecordStorageMigrator.createTokenHolders(dstStore, dstCursors, memoryTracker);
            try (SchemaRuleMigrationAccess dstAccess = RecordStorageEngineFactory.createMigrationTargetSchemaRuleAccess(dstStore, this.contextFactory, memoryTracker);){
                schemaStoreMigration.migrate(dstAccess, dstTokensHolders);
            }
            try (DatabaseFlushEvent databaseFlushEvent = this.pageCacheTracer.beginDatabaseFlush();){
                dstStore.flush(databaseFlushEvent, AsyncBlockAccessor.EMPTY_ASYNC_BLOCK_ACCESSOR, cursorContext);
            }
        }
    }

    private static void deleteBtreeIndexFiles(FileSystemAbstraction fs, RecordDatabaseLayout directoryLayout) throws IOException {
        fs.deleteRecursively(IndexDirectoryStructure.directoriesByProvider((Path)directoryLayout.databaseDirectory()).forProvider(SchemaRule44.NATIVE_BTREE_10).rootDirectory());
        fs.deleteRecursively(IndexDirectoryStructure.directoriesByProvider((Path)directoryLayout.databaseDirectory()).forProvider(SchemaRule44.LUCENE_NATIVE_30).rootDirectory());
    }

    static boolean need50Migration(RecordFormats oldFormat) {
        return oldFormat.hasCapability((Capability)Index44Compatibility.INSTANCE);
    }

    static TokenHolders createTokenHolders(NeoStores stores, CachedStoreCursors cursors, MemoryTracker memoryTracker) {
        TokenHolders tokenHolders = new TokenHolders(StoreTokens.createReadOnlyTokenHolder("PropertyKey"), StoreTokens.createReadOnlyTokenHolder("Label"), StoreTokens.createReadOnlyTokenHolder("RelationshipType"));
        tokenHolders.setInitialTokens(StoreTokens.allTokens(stores), (StoreCursors)cursors, memoryTracker);
        return tokenHolders;
    }

    public void postMigration(DatabaseLayout databaseLayout, StoreVersion toVersion, final long txIdBeforeMigration, long txIdAfterMigration) throws IOException {
        if (txIdBeforeMigration == txIdAfterMigration) {
            return;
        }
        RecordDatabaseLayout recordLayout = RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout);
        RecordFormats format = ((RecordStoreVersion)toVersion).getFormat();
        ImmutableSet<OpenOption> openOptions = PageCacheOptionsSelector.select(format);
        final MutableBoolean countsUpToDate = new MutableBoolean(true);
        CountsBuilder countsBuilder = new CountsBuilder(){

            public void initialize(CountsUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
                countsUpToDate.setFalse();
            }

            public long lastCommittedTxId() {
                return txIdBeforeMigration;
            }
        };
        try (CountsStore countsStore = this.openCountsStore(this.pageCache, this.fileSystem, recordLayout, this.logService.getInternalLogProvider(), RecoveryCleanupWorkCollector.immediate(), countsBuilder, Config.defaults(), this.contextFactory, this.pageCacheTracer, openOptions);
             CursorContext context = this.contextFactory.create("update counts store");
             FileFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush();){
            countsStore.start(context, this.memoryTracker);
            if (countsUpToDate.isTrue()) {
                for (long txId = txIdBeforeMigration + 1L; txId <= txIdAfterMigration; ++txId) {
                    countsStore.updater(txId, true, context).close();
                }
                countsStore.checkpoint(flushEvent, AsyncBlockAccessor.EMPTY_ASYNC_BLOCK_ACCESSOR, context);
            }
        }
        final MutableBoolean degreesUpToDate = new MutableBoolean(true);
        DegreesRebuilder degreesBuilder = new DegreesRebuilder(){

            public void rebuild(DegreeUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
                degreesUpToDate.setFalse();
            }

            public long lastCommittedTxId() {
                return txIdBeforeMigration;
            }
        };
        try (RelationshipGroupDegreesStore degreesStore = DegreeStoreProvider.getInstance().openDegreesStore(this.pageCache, this.fileSystem, recordLayout, this.logService.getInternalLogProvider(), RecoveryCleanupWorkCollector.immediate(), Config.defaults(), this.contextFactory, this.pageCacheTracer, degreesBuilder, openOptions, false, VersionStorage.EMPTY_STORAGE);
             CursorContext context = this.contextFactory.create("update group degrees store");
             FileFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush();){
            degreesStore.start(context, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            if (degreesUpToDate.isTrue()) {
                for (long txId = txIdBeforeMigration + 1L; txId <= txIdAfterMigration; ++txId) {
                    degreesStore.updater(txId, true, context).close();
                }
                degreesStore.checkpoint(flushEvent, AsyncBlockAccessor.EMPTY_ASYNC_BLOCK_ACCESSOR, context);
            }
        }
        if (this.formatsHaveDifferentStoreCapabilities) {
            this.fileSystem.delete(recordLayout.indexStatisticsStore());
        }
    }

    private CountsStore openCountsStore(PageCache pageCache, FileSystemAbstraction fs, RecordDatabaseLayout layout, InternalLogProvider userLogProvider, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, CountsBuilder builder, Config config, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, ImmutableSet<OpenOption> openOptions) {
        return CountsStoreProvider.getInstance().openCountsStore(pageCache, fs, layout, userLogProvider, recoveryCleanupWorkCollector, config, contextFactory, pageCacheTracer, openOptions, builder, false, VersionStorage.EMPTY_STORAGE);
    }

    public void cleanup(DatabaseLayout migrationLayout) throws IOException {
    }

    public String toString() {
        return "Kernel StoreMigrator";
    }

    private static class BatchImporterProgressMonitor
    extends CoarseBoundedProgressExecutionMonitor {
        private final ProgressListener progressReporter;

        BatchImporterProgressMonitor(long highNodeId, long highRelationshipId, Configuration configuration, ProgressListener progressReporter) {
            super(highNodeId, highRelationshipId, configuration);
            this.progressReporter = ProgressMonitorFactory.mapped((ProgressListener)progressReporter, (int)100).singlePart("", this.total());
        }

        protected void progress(long progress) {
            this.progressReporter.add(progress);
        }
    }

    private static class RelationshipRecordChunk
    extends StoreScanChunk<StorageRelationshipScanCursor> {
        private final StoreCursors storeCursors;

        RelationshipRecordChunk(RecordStorageReader storageReader, boolean requiresPropertyMigration, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
            super(storageReader.allocateRelationshipScanCursor(cursorContext, storeCursors, memoryTracker), storageReader, requiresPropertyMigration, cursorContext, storeCursors, memoryTracker);
            this.storeCursors = storeCursors;
        }

        @Override
        protected void read(StorageRelationshipScanCursor cursor, long id) {
            cursor.single(id);
        }

        @Override
        protected void visitRecord(StorageRelationshipScanCursor record, InputEntityVisitor visitor) {
            visitor.startId(record.sourceNodeReference());
            visitor.endId(record.targetNodeReference());
            visitor.type(record.type());
            this.visitProperties(record, visitor);
        }

        @Override
        public void close() {
            super.close();
            this.storeCursors.close();
        }
    }

    private static class NodeRecordChunk
    extends StoreScanChunk<RecordNodeCursor> {
        private final StoreCursors storeCursors;

        NodeRecordChunk(RecordStorageReader storageReader, boolean requiresPropertyMigration, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
            super(storageReader.allocateNodeCursor(cursorContext, storeCursors, memoryTracker), storageReader, requiresPropertyMigration, cursorContext, storeCursors, memoryTracker);
            this.storeCursors = storeCursors;
        }

        @Override
        protected void read(RecordNodeCursor cursor, long id) {
            cursor.single(id);
        }

        @Override
        protected void visitRecord(RecordNodeCursor record, InputEntityVisitor visitor) {
            visitor.id(record.entityReference());
            visitor.labelField(record.getLabelField());
            this.visitProperties(record, visitor);
        }

        @Override
        public void close() {
            super.close();
            this.storeCursors.close();
        }
    }
}

