/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionUserStringProvider;
import org.neo4j.storageengine.api.format.Capability;
import org.neo4j.storageengine.api.format.CapabilityType;

public class RecordStoreVersion
implements StoreVersion {
    private final RecordFormats format;

    public RecordStoreVersion(RecordFormats format) {
        this.format = format;
    }

    public boolean hasCapability(Capability capability) {
        return this.format.hasCapability(capability);
    }

    public boolean hasCompatibleCapabilities(StoreVersion otherVersion, CapabilityType type) {
        if (otherVersion instanceof RecordStoreVersion) {
            return this.format.hasCompatibleCapabilities(((RecordStoreVersion)otherVersion).format, type);
        }
        return false;
    }

    public String introductionNeo4jVersion() {
        return this.format.introductionVersion();
    }

    public Optional<StoreVersion> successorStoreVersion(Config config) {
        RecordFormats latestFormatInFamily = RecordFormatSelector.findLatestFormatInFamily(this.format.getFormatFamily().name(), config);
        if (!latestFormatInFamily.name().equals(this.format.name())) {
            return Optional.of(new RecordStoreVersion(latestFormatInFamily));
        }
        return Optional.empty();
    }

    public String formatName() {
        return this.format.getFormatFamily().name();
    }

    public boolean onlyForMigration() {
        return this.format.onlyForMigration();
    }

    public RecordFormats getFormat() {
        return this.format;
    }

    public String toString() {
        return "RecordStoreVersion{format=" + String.valueOf(this.format) + "}";
    }

    public String getStoreVersionUserString() {
        return StoreVersionUserStringProvider.formatVersion((String)"record", (String)this.formatName(), (int)this.format.majorVersion(), (int)this.format.minorVersion());
    }
}

