/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacy;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorImplementation;
import org.neo4j.internal.schema.SchemaPatternMatchingType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.IntStoreHeaderFormat;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.storemigration.SchemaStore44MigrationUtil;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertyKeyValue;
import org.neo4j.storageengine.api.SchemaRule44;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;

public class SchemaStore44Reader
implements AutoCloseable {
    private static final String PROP_SCHEMA_RULE_PREFIX = "__org.neo4j.SchemaRule.";
    private static final String PROP_SCHEMA_RULE_TYPE = "__org.neo4j.SchemaRule.schemaRuleType";
    private static final String PROP_INDEX_RULE_TYPE = "__org.neo4j.SchemaRule.indexRuleType";
    private static final String PROP_CONSTRAINT_RULE_TYPE = "__org.neo4j.SchemaRule.constraintRuleType";
    private static final String PROP_SCHEMA_RULE_NAME = "__org.neo4j.SchemaRule.name";
    private static final String PROP_OWNED_INDEX = "__org.neo4j.SchemaRule.ownedIndex";
    private static final String PROP_OWNING_CONSTRAINT = "__org.neo4j.SchemaRule.owningConstraint";
    private static final String PROP_INDEX_PROVIDER_NAME = "__org.neo4j.SchemaRule.indexProviderName";
    private static final String PROP_INDEX_PROVIDER_VERSION = "__org.neo4j.SchemaRule.indexProviderVersion";
    private static final String PROP_SCHEMA_DESCRIPTOR_ENTITY_TYPE = "__org.neo4j.SchemaRule.schemaEntityType";
    private static final String PROP_SCHEMA_DESCRIPTOR_ENTITY_IDS = "__org.neo4j.SchemaRule.schemaEntityIds";
    private static final String PROP_SCHEMA_DESCRIPTOR_PROPERTY_IDS = "__org.neo4j.SchemaRule.schemaPropertyIds";
    private static final String PROP_SCHEMA_DESCRIPTOR_SCHEMA_PATTERN_MATCHING_TYPE = "__org.neo4j.SchemaRule.schemaPropertySchemaType";
    private static final String PROP_INDEX_TYPE = "__org.neo4j.SchemaRule.indexType";
    private static final String PROP_INDEX_CONFIG_PREFIX = "__org.neo4j.SchemaRule.IndexConfig.";
    private static final Function<Long, SchemaRule44.Index> FORMER_LABEL_SCAN_STORE_SCHEMA_RULE_FACTORY = id -> new SchemaRule44.Index(id.longValue(), (SchemaDescriptor)SchemaStore44MigrationUtil.FORMER_LABEL_SCAN_STORE_SCHEMA, false, "__org_neo4j_schema_index_label_scan_store_converted_to_token_index", SchemaRule44.IndexType.LOOKUP, new IndexProviderDescriptor("token-lookup", "1.0"), IndexConfig.empty(), null);
    private final SchemaStore44 schemaStore;
    private final PropertyStore propertyStore;
    private final TokenHolders tokenHolders;
    private final KernelVersion kernelVersion;

    public SchemaStore44Reader(FileSystemAbstraction fileSystem, PropertyStore propertyStore, TokenHolders tokenHolders, KernelVersion kernelVersion, Path schemaStoreLocation, Path idFile, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, PageCacheTracer pageCacheTracer, CursorContextFactory cursorContextFactory, InternalLogProvider logProvider, RecordFormats recordFormats, String databaseName, ImmutableSet<OpenOption> openOptions) {
        this.propertyStore = propertyStore;
        this.tokenHolders = tokenHolders;
        this.kernelVersion = kernelVersion;
        this.schemaStore = new SchemaStore44(fileSystem, schemaStoreLocation, idFile, conf, idType, idGeneratorFactory, pageCache, pageCacheTracer, cursorContextFactory, logProvider, recordFormats, databaseName, openOptions);
    }

    public List<SchemaRule44> loadAllSchemaRules(StoreCursors storeCursors, MemoryTracker memoryTracker) {
        long startId = this.schemaStore.getNumberOfReservedLowIds();
        long endId = this.schemaStore.getIdGenerator().getHighId();
        ArrayList<SchemaRule44> schemaRules = new ArrayList<SchemaRule44>();
        this.maybeAddFormerLabelScanStore(schemaRules);
        for (long id = startId; id < endId; ++id) {
            SchemaRecord schemaRecord = this.schemaStore.getRecordByCursor(id, (SchemaRecord)this.schemaStore.newRecord(), RecordLoad.LENIENT_ALWAYS, storeCursors.readCursor((CursorType)RecordCursorTypes.SCHEMA_CURSOR), memoryTracker);
            if (!schemaRecord.inUse()) continue;
            try {
                Map<String, Value> propertyKeyValue = this.schemaRecordToMap(schemaRecord, storeCursors, memoryTracker);
                SchemaRule44 schemaRule = this.createSchemaRule(id, propertyKeyValue);
                schemaRules.add(schemaRule);
                continue;
            }
            catch (MalformedSchemaRuleException malformedSchemaRuleException) {
                // empty catch block
            }
        }
        return schemaRules;
    }

    private void maybeAddFormerLabelScanStore(List<SchemaRule44> schemaRules) {
        if (this.kernelVersion.isLessThan(KernelVersion.VERSION_IN_WHICH_TOKEN_INDEXES_ARE_INTRODUCED)) {
            schemaRules.add(SchemaStore44Reader.constructFormerLabelScanStoreSchemaRule());
        }
    }

    private Map<String, Value> schemaRecordToMap(SchemaRecord record, StoreCursors storeCursors, MemoryTracker memoryTracker) throws MalformedSchemaRuleException {
        HashMap<String, Value> props = new HashMap<String, Value>();
        PropertyRecord propRecord = this.propertyStore.newRecord();
        long nextProp = record.getNextProp();
        while (nextProp != Record.NO_NEXT_PROPERTY.longValue()) {
            try {
                this.propertyStore.getRecordByCursor(nextProp, propRecord, RecordLoad.NORMAL, storeCursors.readCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR), memoryTracker);
            }
            catch (InvalidRecordException e) {
                throw MalformedSchemaRuleException.internalError((String)this.getClass().getSimpleName(), (String)("Cannot read schema rule because it is referencing a property record (id " + nextProp + ") that is invalid: " + String.valueOf(propRecord)), (Throwable)((Object)e));
            }
            for (PropertyBlock propertyBlock : propRecord.propertyBlocks()) {
                PropertyKeyValue propertyKeyValue = propertyBlock.newPropertyKeyValue(this.propertyStore, storeCursors, memoryTracker);
                SchemaStore44Reader.insertPropertyIntoMap(propertyKeyValue, props, this.tokenHolders);
            }
            nextProp = propRecord.getNextProp();
        }
        return props;
    }

    private static void insertPropertyIntoMap(PropertyKeyValue propertyKeyValue, Map<String, Value> props, TokenHolders tokenHolders) throws MalformedSchemaRuleException {
        try {
            NamedToken propertyKeyTokenName = tokenHolders.propertyKeyTokens().getInternalTokenById(propertyKeyValue.propertyKeyId());
            props.put(propertyKeyTokenName.name(), propertyKeyValue.value());
        }
        catch (InvalidRecordException | TokenNotFoundException e) {
            int id = propertyKeyValue.propertyKeyId();
            throw MalformedSchemaRuleException.internalError((String)SchemaStore44Reader.class.getSimpleName(), (String)("Cannot read schema rule because it is referring to a property key token (id " + id + ") that does not exist."), (Throwable)e);
        }
    }

    private SchemaRule44 createSchemaRule(long ruleId, Map<String, Value> props) throws MalformedSchemaRuleException {
        String schemaRuleType;
        if (props.isEmpty()) {
            return SchemaStore44Reader.constructFormerLabelScanStoreSchemaRule(ruleId);
        }
        return switch (schemaRuleType = SchemaStore44Reader.getString(PROP_SCHEMA_RULE_TYPE, props)) {
            case "INDEX" -> SchemaStore44Reader.buildIndexRule(ruleId, props);
            case "CONSTRAINT" -> SchemaStore44Reader.buildConstraintRule(ruleId, props);
            default -> throw MalformedSchemaRuleException.internalError((String)this.getClass().getSimpleName(), (String)("Can not create a schema rule of type: " + schemaRuleType));
        };
    }

    public static SchemaRule44 constructFormerLabelScanStoreSchemaRule() {
        return SchemaStore44Reader.constructFormerLabelScanStoreSchemaRule(-2L);
    }

    public static SchemaRule44 constructFormerLabelScanStoreSchemaRule(long ruleId) {
        return (SchemaRule44)FORMER_LABEL_SCAN_STORE_SCHEMA_RULE_FACTORY.apply(ruleId);
    }

    private static SchemaRule44.Index buildIndexRule(long schemaRuleId, Map<String, Value> props) throws MalformedSchemaRuleException {
        SchemaDescriptor schema = SchemaStore44Reader.buildSchemaDescriptor(props);
        boolean unique = SchemaStore44Reader.parseIndexRuleType(SchemaStore44Reader.getString(PROP_INDEX_RULE_TYPE, props));
        String name = SchemaStore44Reader.getString(PROP_SCHEMA_RULE_NAME, props);
        SchemaRule44.IndexType indexType = SchemaStore44Reader.getIndexType(SchemaStore44Reader.getString(PROP_INDEX_TYPE, props));
        IndexConfig indexConfig = SchemaStore44Reader.extractIndexConfig(props);
        String providerKey = SchemaStore44Reader.getString(PROP_INDEX_PROVIDER_NAME, props);
        String providerVersion = SchemaStore44Reader.getString(PROP_INDEX_PROVIDER_VERSION, props);
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor(providerKey, providerVersion);
        Long owningConstraintId = null;
        if (props.containsKey(PROP_OWNING_CONSTRAINT)) {
            owningConstraintId = SchemaStore44Reader.getLong(PROP_OWNING_CONSTRAINT, props);
        }
        return new SchemaRule44.Index(schemaRuleId, schema, unique, name, indexType, providerDescriptor, indexConfig, owningConstraintId);
    }

    private static SchemaRule44.Constraint buildConstraintRule(long id, Map<String, Value> props) throws MalformedSchemaRuleException {
        SchemaDescriptor schema = SchemaStore44Reader.buildSchemaDescriptor(props);
        SchemaRule44.ConstraintRuleType constraintRuleType = SchemaStore44Reader.getConstraintRuleType(SchemaStore44Reader.getString(PROP_CONSTRAINT_RULE_TYPE, props));
        String name = SchemaStore44Reader.getString(PROP_SCHEMA_RULE_NAME, props);
        Long ownedIndex = SchemaStore44Reader.getOptionalLong(PROP_OWNED_INDEX, props);
        SchemaRule44.IndexType indexType = SchemaStore44Reader.getIndexType(SchemaStore44Reader.getOptionalString(PROP_INDEX_TYPE, props));
        return new SchemaRule44.Constraint(id, schema, name, constraintRuleType, ownedIndex, indexType);
    }

    private static boolean parseIndexRuleType(String indexRuleType) throws MalformedSchemaRuleException {
        return switch (indexRuleType) {
            case "NON_UNIQUE" -> false;
            case "UNIQUE" -> true;
            default -> throw MalformedSchemaRuleException.internalError((String)SchemaStore44Reader.class.getSimpleName(), (String)("Did not recognize index rule type: " + indexRuleType));
        };
    }

    private static SchemaDescriptor buildSchemaDescriptor(Map<String, Value> props) throws MalformedSchemaRuleException {
        EntityType entityType = SchemaStore44Reader.getEntityType(SchemaStore44Reader.getString(PROP_SCHEMA_DESCRIPTOR_ENTITY_TYPE, props));
        SchemaPatternMatchingType schemaPatternMatchingType = SchemaStore44Reader.getSchemaPatternMatchingType(SchemaStore44Reader.getString(PROP_SCHEMA_DESCRIPTOR_SCHEMA_PATTERN_MATCHING_TYPE, props));
        int[] entityIds = SchemaStore44Reader.getIntArray(PROP_SCHEMA_DESCRIPTOR_ENTITY_IDS, props);
        int[] propertyIds = SchemaStore44Reader.getIntArray(PROP_SCHEMA_DESCRIPTOR_PROPERTY_IDS, props);
        return new SchemaDescriptorImplementation(entityType, schemaPatternMatchingType, entityIds, propertyIds);
    }

    private static IndexConfig extractIndexConfig(Map<String, Value> props) {
        HashMap<String, Value> configMap = new HashMap<String, Value>();
        for (Map.Entry<String, Value> entry : props.entrySet()) {
            if (!entry.getKey().startsWith(PROP_INDEX_CONFIG_PREFIX)) continue;
            configMap.put(entry.getKey().substring(PROP_INDEX_CONFIG_PREFIX.length()), entry.getValue());
        }
        return IndexConfig.with(configMap);
    }

    private static SchemaRule44.IndexType getIndexType(String indexType) throws MalformedSchemaRuleException {
        if (indexType == null) {
            return null;
        }
        try {
            return SchemaRule44.IndexType.valueOf((String)indexType);
        }
        catch (Exception e) {
            throw MalformedSchemaRuleException.internalError((String)SchemaStore44Reader.class.getSimpleName(), (String)("Did not recognize index type: " + indexType), (Throwable)e);
        }
    }

    private static SchemaRule44.ConstraintRuleType getConstraintRuleType(String constraintRuleType) throws MalformedSchemaRuleException {
        try {
            return SchemaRule44.ConstraintRuleType.valueOf((String)constraintRuleType);
        }
        catch (Exception e) {
            throw MalformedSchemaRuleException.internalError((String)SchemaStore44Reader.class.getSimpleName(), (String)("Did not recognize constraint rule type: " + constraintRuleType), (Throwable)e);
        }
    }

    private static SchemaPatternMatchingType getSchemaPatternMatchingType(String schemaPatternMatchingType) throws MalformedSchemaRuleException {
        try {
            return SchemaPatternMatchingType.valueOf((String)schemaPatternMatchingType);
        }
        catch (Exception e) {
            throw MalformedSchemaRuleException.internalError((String)SchemaStore44Reader.class.getSimpleName(), (String)("Did not recognize schema pattern matching type: " + schemaPatternMatchingType), (Throwable)e);
        }
    }

    private static EntityType getEntityType(String entityType) throws MalformedSchemaRuleException {
        try {
            return EntityType.valueOf((String)entityType);
        }
        catch (Exception e) {
            throw MalformedSchemaRuleException.internalError((String)SchemaStore44Reader.class.getSimpleName(), (String)("Did not recognize entity type: " + entityType), (Throwable)e);
        }
    }

    private static int[] getIntArray(String property, Map<String, Value> props) throws MalformedSchemaRuleException {
        Value value = props.get(property);
        if (value instanceof IntArray) {
            return (int[])value.asObject();
        }
        throw MalformedSchemaRuleException.propertyTypeMismatch((String)property, (Value)value, IntArray.class);
    }

    private static long getLong(String property, Map<String, Value> props) throws MalformedSchemaRuleException {
        Value value = props.get(property);
        if (value instanceof LongValue) {
            return ((LongValue)value).value();
        }
        throw MalformedSchemaRuleException.propertyTypeMismatch((String)property, (Value)value, LongValue.class);
    }

    private static Long getOptionalLong(String property, Map<String, Value> props) {
        Value value = props.get(property);
        if (value instanceof LongValue) {
            return ((LongValue)value).value();
        }
        return null;
    }

    private static String getString(String property, Map<String, Value> map) throws MalformedSchemaRuleException {
        Value value = map.get(property);
        if (value instanceof TextValue) {
            return ((TextValue)value).stringValue();
        }
        throw MalformedSchemaRuleException.propertyTypeMismatch((String)property, (Value)value, TextValue.class);
    }

    private static String getOptionalString(String property, Map<String, Value> map) {
        Value value = map.get(property);
        if (value instanceof TextValue) {
            return ((TextValue)value).stringValue();
        }
        return null;
    }

    @Override
    public void close() {
        this.schemaStore.close();
    }

    private static class SchemaStore44
    extends CommonAbstractStore<SchemaRecord, IntStoreHeader> {
        private static final IntStoreHeaderFormat VALID_STORE_HEADER = new IntStoreHeaderFormat(0);
        private static final String TYPE_DESCRIPTOR = "SchemaStore44";

        SchemaStore44(FileSystemAbstraction fileSystem, Path path, Path idFile, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, PageCacheTracer pageCacheTracer, CursorContextFactory cursorContextFactory, InternalLogProvider logProvider, RecordFormats recordFormats, String databaseName, ImmutableSet<OpenOption> openOptions) {
            super(fileSystem, path, idFile, conf, idType, idGeneratorFactory, pageCache, pageCacheTracer, logProvider, TYPE_DESCRIPTOR, recordFormats.schema(), VALID_STORE_HEADER, true, databaseName, openOptions);
            this.initialise(cursorContextFactory);
        }
    }
}

