/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.bootstrap;

import com.neo4j.fleetmanagement.bootstrap.MainService;
import com.neo4j.fleetmanagement.bootstrap.PluginBuildProfile;
import com.neo4j.fleetmanagement.bootstrap.Reflection;
import com.neo4j.fleetmanagement.bootstrap.logprovider.ILogProvider;
import com.neo4j.fleetmanagement.communication.ConfigService;
import com.neo4j.fleetmanagement.communication.ConnectService;
import com.neo4j.fleetmanagement.communication.MetricsService;
import com.neo4j.fleetmanagement.communication.PingService;
import com.neo4j.fleetmanagement.communication.TopologyService;
import com.neo4j.fleetmanagement.communication.upstream.Upstream;
import com.neo4j.fleetmanagement.configuration.ClusterSync;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import com.neo4j.fleetmanagement.utils.Logger;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

public class FleetManagement
extends LifecycleAdapter {
    private final ITransactor transactor;
    private final MainService mainService;
    private final Log log;

    public FleetManagement(LogService logService, DatabaseManagementService databaseManagementService, GlobalProcedures globalProcedures, Config config, DbmsInfo dbmsInfo, FileSystemAbstraction fs, ServerIdentity serverIdentity, PluginBuildProfile pluginBuildProfile) {
        try {
            Log neo4jLog = Reflection.getNewInstanceOfImplementationOf(ILogProvider.class, new Object[0]).getLog(logService);
            Logger.initLogger(neo4jLog);
            this.log = Logger.getNeo4jLogger();
            this.transactor = Reflection.getConstructorOfImplementationOf(ITransactor.class, DbmsInfo.class, ServerIdentity.class).newInstance(dbmsInfo, serverIdentity);
            this.transactor.init(databaseManagementService);
            globalProcedures.registerComponent(ITransactor.class, ctx -> this.transactor, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setName("neo4j.FleetManagement");
            thread.setUncaughtExceptionHandler((t, e) -> Logger.getPluginLogger().debug(String.format("Uncaught exception in FleetManagement thread: %s", ExceptionUtils.getStackTrace((Throwable)e))));
            return thread;
        });
        Upstream upstream = new Upstream(this.transactor);
        ConnectService connectService = new ConnectService(config, fs, this.transactor, serverIdentity, upstream, pluginBuildProfile);
        TopologyService reportingService = new TopologyService(config, fs, this.transactor, serverIdentity, upstream);
        MetricsService metricsService = new MetricsService(this.transactor, serverIdentity, upstream, config, pluginBuildProfile);
        new ConfigService(this.transactor, serverIdentity, upstream, config);
        PingService pingService = new PingService(config, fs, this.transactor, upstream, serverIdentity);
        ClusterSync clusterSync = new ClusterSync(this.transactor, upstream);
        this.mainService = new MainService(this.transactor, upstream, reportingService, metricsService, clusterSync, scheduler, connectService, pingService);
    }

    public void start() {
        this.log.info("This server is equipped with fleet management");
        this.mainService.start();
    }

    public void stop() {
        this.log.info("Stopping the fleet management plugin");
        this.mainService.stop();
    }

    public void shutdown() {
        this.log.info("Shutting down fleet management");
    }
}

