/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.bootstrap;

import com.neo4j.fleetmanagement.communication.ConnectService;
import com.neo4j.fleetmanagement.communication.MetricsService;
import com.neo4j.fleetmanagement.communication.PingService;
import com.neo4j.fleetmanagement.communication.TopologyService;
import com.neo4j.fleetmanagement.communication.upstream.Upstream;
import com.neo4j.fleetmanagement.configuration.ClusterSync;
import com.neo4j.fleetmanagement.configuration.Configuration;
import com.neo4j.fleetmanagement.configuration.State;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import com.neo4j.fleetmanagement.utils.Logger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.logging.Log;

public class MainService
implements PropertyChangeListener {
    private final Log userLog = Logger.getNeo4jLogger();
    private final Logger pluginLog = Logger.getPluginLogger();
    private final TopologyService topologyService;
    private final MetricsService metricsService;
    private final PingService pingService;
    private final ClusterSync clusterSync;
    private final ScheduledExecutorService scheduler;
    private final ConnectService connectService;
    private final State state;
    private ScheduledFuture<?> connectServiceTaskHandle;
    private Boolean lastActiveState = null;
    private Boolean lastConnectedState = null;
    private Boolean lastTokenRotatingState = null;
    private final CopyOnWriteArrayList<ScheduledFuture<?>> jobHandles;
    private final Configuration configuration;

    public MainService(ITransactor transactor, Upstream upstream, TopologyService topologyService, MetricsService metricsService, ClusterSync clusterSync, ScheduledExecutorService scheduler, ConnectService connectService, PingService pingService) {
        this.topologyService = topologyService;
        this.metricsService = metricsService;
        this.pingService = pingService;
        this.clusterSync = clusterSync;
        this.scheduler = scheduler;
        this.connectService = connectService;
        this.configuration = Configuration.getInstance();
        this.state = State.getInstance();
        this.jobHandles = new CopyOnWriteArrayList();
    }

    public void start() {
        if (!this.jobHandles.isEmpty()) {
            throw new IllegalStateException("Service already started");
        }
        this.state.addPropertyChangeListener(this);
        this.configuration.addPropertyChangeListener(this);
        this.connectServiceTaskHandle = this.scheduler.scheduleAtFixedRate(new ConnectService.ConnectServiceTask(this.state, this.clusterSync, this.connectService), 1L, 30L, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.connectServiceTaskHandle != null) {
            this.connectServiceTaskHandle.cancel(false);
            this.connectServiceTaskHandle = null;
        }
        this.stopReportingTasks();
        if (this.state.isConnected()) {
            this.connectService.disconnect("Service is stopped");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "active": {
                this.activeStateChangeHandler(evt);
                return;
            }
            case "connected": {
                this.connectedStateChangeHandler(evt);
                return;
            }
            case "rotatingToken": {
                this.tokenRotatingStateChangeHandler(evt);
                return;
            }
            case "taskReportingInterval": {
                this.handleConfigurationUpdate();
            }
        }
    }

    private void tokenRotatingStateChangeHandler(PropertyChangeEvent evt) {
        Boolean value = (Boolean)evt.getNewValue();
        if (this.lastTokenRotatingState != null && this.lastTokenRotatingState.equals(value)) {
            return;
        }
        this.lastTokenRotatingState = value;
        if (value.booleanValue()) {
            this.userLog.info("Fleet management token is being rotated");
            this.connectService.reconnect("Token is being rotated");
        } else {
            this.userLog.info("Fleet management token is now rotated");
        }
    }

    private void connectedStateChangeHandler(PropertyChangeEvent evt) {
        Boolean value = (Boolean)evt.getNewValue();
        if (this.lastConnectedState != null && this.lastConnectedState.equals(value)) {
            return;
        }
        this.lastConnectedState = value;
        if (value.booleanValue()) {
            this.startReportingTasks();
            this.userLog.info("Fleet management connection successfully established");
        } else {
            this.stopReportingTasks();
            this.userLog.info("Fleet management connection was closed");
        }
    }

    private void activeStateChangeHandler(PropertyChangeEvent evt) {
        Boolean value = (Boolean)evt.getNewValue();
        if (this.lastActiveState != null && this.lastActiveState.equals(value)) {
            return;
        }
        this.lastActiveState = value;
        if (value.booleanValue()) {
            this.state.setConnectionMessage("Connecting");
            this.userLog.info("Fleet management is enabled");
        } else {
            if (this.state.isConnected()) {
                this.connectService.disconnect(null);
            }
            this.userLog.info("Fleet management is disabled. Use the procedure fleetManagement.registerToken to get started.");
        }
    }

    private void startReportingTasks() {
        Map<Configuration.TaskType, Long> taskReportingInterval = this.configuration.getTaskReportingInterval();
        if (taskReportingInterval == null || taskReportingInterval.isEmpty()) {
            if (this.state.isConnected()) {
                this.connectService.disconnect("Reporting intervals are not configured.");
            }
            return;
        }
        taskReportingInterval.forEach((taskType, interval) -> {
            switch (taskType) {
                case TOPOLOGY: {
                    this.jobHandles.add(this.scheduler.scheduleAtFixedRate(new TopologyService.TopologyReportingTask(this.state, this.clusterSync, this.topologyService), 1L, (long)interval, TimeUnit.SECONDS));
                    break;
                }
                case METRICS: {
                    this.jobHandles.add(this.scheduler.scheduleAtFixedRate(new MetricsService.MetricsReportingTask(this.state, this.clusterSync, this.metricsService), 1L, (long)interval, TimeUnit.SECONDS));
                    break;
                }
                case PING: {
                    this.jobHandles.add(this.scheduler.scheduleAtFixedRate(new PingService.PingTask(this.state, this.clusterSync, this.pingService), (long)interval, (long)interval, TimeUnit.SECONDS));
                    break;
                }
            }
        });
    }

    private void stopReportingTasks() {
        this.pluginLog.debug(String.format("Stopping reporting tasks from: %s", ExceptionUtils.getStackTrace((Throwable)new Throwable())));
        if (!this.jobHandles.isEmpty()) {
            this.jobHandles.forEach((Consumer<ScheduledFuture<?>>)((Consumer<ScheduledFuture>)jobHandle -> jobHandle.cancel(false)));
            this.jobHandles.clear();
        }
    }

    private void handleConfigurationUpdate() {
        if (this.state.isConnected()) {
            this.userLog.info("Configuration updated, restarting reporting tasks with new intervals");
            this.stopReportingTasks();
            this.startReportingTasks();
        }
    }
}

