/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.bootstrap;

import com.neo4j.fleetmanagement.configuration.ClusterSync;
import com.neo4j.fleetmanagement.configuration.State;
import com.neo4j.fleetmanagement.utils.Logger;
import org.neo4j.logging.Log;

public abstract class PluginTask
implements Runnable {
    protected final Log userLog = Logger.getNeo4jLogger();
    protected final Logger pluginLog = Logger.getPluginLogger();
    protected final State state;
    protected final ClusterSync clusterSync;

    public PluginTask(State state, ClusterSync clusterSync) {
        this.state = state;
        this.clusterSync = clusterSync;
    }

    @Override
    public void run() {
        String className = this.getClass().getSimpleName();
        try {
            this.pluginLog.debug(String.format("Running %s", className));
            this.clusterSync.run();
            this.execute();
        }
        catch (Exception e) {
            this.userLog.error("Plugin failed to run " + className, (Throwable)e);
        }
        catch (Error e) {
            this.userLog.error("Plugin failed to run " + className + " with Error", (Throwable)e);
            throw e;
        }
    }

    protected abstract void execute();
}

