/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.common;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Supplier;

public class CachedMethod<T> {
    private T cachedValue;
    private Instant lastCacheTime;
    private static final Duration CACHE_DURATION = Duration.ofHours(1L);

    public T GetCachedOrRun(Supplier<T> supplier) {
        Instant now = Instant.now();
        if (this.cachedValue != null && this.lastCacheTime != null && Duration.between(this.lastCacheTime, now).compareTo(CACHE_DURATION) < 0) {
            return this.cachedValue;
        }
        this.cachedValue = supplier.get();
        this.lastCacheTime = now;
        return this.cachedValue;
    }
}

