/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.common;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.neo4j.logging.Log;

public class Retry<T> {
    private int maxAttempts = 10;
    private AtomicLong backoff = new AtomicLong(10L);
    private TimeUnit backoffUnit = TimeUnit.SECONDS;
    private AtomicInteger attempts = new AtomicInteger(0);
    private RetryStrategy retryStrategy = RetryStrategy.FIXED_BACKOFF;
    private Callable<T> callable;
    private Predicate<T> predicate;
    private String failureMessage = "";
    private Log logger;

    public Retry(Log log) {
        this.logger = log;
    }

    public Retry<T> withFixedBackOff(long backoff, TimeUnit backoffUnit) {
        this.backoff.set(backoff);
        this.backoffUnit = backoffUnit;
        return this;
    }

    public Retry<T> withMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    public Retry<T> withExponentialBackoff(long initialBackoff, TimeUnit backoffUnit) {
        this.backoff.set(initialBackoff);
        this.backoffUnit = backoffUnit;
        return this;
    }

    public Retry<T> withFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
        return this;
    }

    public Retry<T> withRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
        return this;
    }

    public Retry<T> withCallable(Callable<T> callable) {
        this.callable = callable;
        return this;
    }

    public Retry<T> withPredicate(Predicate<T> predicate) {
        this.predicate = predicate;
        return this;
    }

    public T call() {
        switch (this.retryStrategy) {
            case EXPONENTIAL_BACKOFF: {
                return this.retryWithExponentialBackoff();
            }
            case FIXED_BACKOFF: {
                return this.retryWithFixedBackoff();
            }
        }
        try {
            return this.callable.call();
        }
        catch (Exception e) {
            this.logger.error(this.failureMessage, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private T retryWithExponentialBackoff() {
        try {
            T result = this.callable.call();
            if (this.predicate != null && this.predicate.test(result)) {
                throw new Exception("Did not pass predicate test");
            }
            return result;
        }
        catch (Exception e) {
            if (this.attempts.incrementAndGet() < this.maxAttempts) {
                this.logger.warn(String.format("Retrying due to - %s", this.failureMessage), (Throwable)e);
                long backoff = Math.round((double)this.backoff.get() * Math.pow(2.0, this.attempts.get()));
                try {
                    Thread.sleep(Duration.of(backoff, this.backoffUnit.toChronoUnit()).toMillis());
                }
                catch (InterruptedException ex) {
                    this.logger.error(String.format("Stopped retrying after `%d%s` and %d attempts due to interruption - %s", this.backoff.get(), this.backoffUnit.name(), this.attempts.get(), this.failureMessage), (Throwable)e);
                    throw new RuntimeException(e);
                }
                this.backoff.set(backoff);
                return this.call();
            }
            this.logger.error(String.format("Stopped retrying after `%d%s` and %d attempts - %s", this.backoff.get(), this.backoffUnit.name(), this.attempts.get(), this.failureMessage), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private T retryWithFixedBackoff() {
        try {
            T result = this.callable.call();
            if (this.predicate != null && this.predicate.test(result)) {
                throw new Exception("Did not pass predicate test");
            }
            return this.callable.call();
        }
        catch (Exception e) {
            if (this.attempts.incrementAndGet() < this.maxAttempts) {
                this.logger.warn(String.format("Retrying due to - %s", this.failureMessage), (Throwable)e);
                try {
                    Thread.sleep(Duration.of(this.backoff.get(), this.backoffUnit.toChronoUnit()).toMillis());
                }
                catch (InterruptedException ex) {
                    this.logger.error(String.format("Stopped retrying after `%d%s` and %d attempts due to interruption - %s", this.backoff.get(), this.backoffUnit.name(), this.attempts.get(), this.failureMessage), (Throwable)e);
                    throw new RuntimeException(e);
                }
                return this.call();
            }
            this.logger.error(String.format("Stopped retrying after `%d%s` and %d attempts - %s", this.backoff.get(), this.backoffUnit.name(), this.attempts.get(), this.failureMessage), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static enum RetryStrategy {
        EXPONENTIAL_BACKOFF,
        FIXED_BACKOFF;

    }
}

