/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.communication;

import com.neo4j.fleetmanagement.communication.AbstractReportingService;
import com.neo4j.fleetmanagement.communication.model.Neo4jConfigMessage;
import com.neo4j.fleetmanagement.communication.upstream.Upstream;
import com.neo4j.fleetmanagement.configuration.State;
import com.neo4j.fleetmanagement.topology.Neo4jConfigMapper;
import com.neo4j.fleetmanagement.topology.TopologyMapper;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.identity.ServerIdentity;

public class ConfigService
extends AbstractReportingService
implements PropertyChangeListener {
    private final Neo4jConfigMapper neo4jConfigMapper;
    private final ITransactor transactor;
    private final ServerIdentity serverIdentity;

    public ConfigService(ITransactor transactor, ServerIdentity serverIdentity, Upstream upstream, Config config) {
        super(transactor, upstream);
        this.neo4jConfigMapper = new Neo4jConfigMapper(config);
        this.transactor = transactor;
        this.serverIdentity = serverIdentity;
        State state = State.getInstance();
        state.addPropertyChangeListener(this);
    }

    @Override
    public void report() {
        Neo4jConfigMessage configMessage = new Neo4jConfigMessage();
        configMessage.neo4jConfig = this.neo4jConfigMapper.mapConfig();
        configMessage.dbmsId = TopologyMapper.getDbmsId(this.transactor.getDatabases());
        configMessage.serverId = this.serverIdentity.serverId().uuid().toString();
        configMessage.projectId = this.upstream.getApiKey().projectId();
        this.transmitReport(configMessage, Upstream.Endpoint.CONFIG);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Boolean isTopologyInitialized;
        if (evt.getPropertyName().equals("topologyInitialized") && (isTopologyInitialized = (Boolean)evt.getNewValue()).booleanValue()) {
            this.report();
        }
    }
}

