/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.communication;

import com.neo4j.fleetmanagement.bootstrap.PluginTask;
import com.neo4j.fleetmanagement.communication.AbstractReportingService;
import com.neo4j.fleetmanagement.communication.model.ReportingMessage;
import com.neo4j.fleetmanagement.communication.upstream.Upstream;
import com.neo4j.fleetmanagement.configuration.ClusterSync;
import com.neo4j.fleetmanagement.configuration.State;
import com.neo4j.fleetmanagement.metrics.ServerMetadata;
import com.neo4j.fleetmanagement.topology.TopologyMapper;
import com.neo4j.fleetmanagement.topology.model.Dbms;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.io.fs.FileSystemAbstraction;

public class TopologyService
extends AbstractReportingService {
    private final TopologyMapper topologyMapper;

    public TopologyService(Config config, FileSystemAbstraction fs, ITransactor transactor, ServerIdentity serverIdentity, Upstream upstream) {
        super(transactor, upstream);
        this.topologyMapper = new TopologyMapper(config, fs, transactor, serverIdentity);
    }

    @Override
    public void report() {
        Dbms dbmsData;
        if (!this.state.isConnected()) {
            return;
        }
        try {
            dbmsData = this.topologyMapper.mapTopology();
        }
        catch (Exception e) {
            this.userLog.error("Fleet management plugin failed to report - exception in mapTopology ", (Throwable)e);
            return;
        }
        ReportingMessage msg = new ReportingMessage();
        try {
            ServerMetadata.getInstance().populateStaticInfo(msg);
        }
        catch (Exception e) {
            this.userLog.error("Fleet management plugin failed to collect static information: " + e.getMessage());
            throw new RuntimeException(e);
        }
        msg.dbms = dbmsData;
        msg.projectId = this.upstream.getApiKey().projectId();
        this.transmitReport(msg, Upstream.Endpoint.REPORTING);
        if (!this.state.isTopologyInitialized()) {
            this.state.setTopologyInitialized(true);
        }
    }

    public static class TopologyReportingTask
    extends PluginTask {
        private final TopologyService topologyService;

        public TopologyReportingTask(State state, ClusterSync clusterSync, TopologyService topologyService) {
            super(state, clusterSync);
            this.topologyService = topologyService;
        }

        @Override
        public void execute() {
            if (this.state.isConnected()) {
                this.topologyService.report();
            }
        }
    }
}

