/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.communication.model;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.neo4j.fleetmanagement.common.ValuesDocumentation;
import com.neo4j.fleetmanagement.communication.model.DataPoint;
import com.neo4j.fleetmanagement.procedures.MetricNamesSupplier;
import java.time.Instant;
import java.util.List;
import java.util.Map;

@JsonClassDescription(value="Message sent from the plugin to the Fleet Management service containing metrics data.")
public class MetricsMessage {
    @JsonPropertyDescription(value="Unix timestamp in milliseconds when the message was created")
    public long timestamp = Instant.now().toEpochMilli();
    @JsonProperty(value="project_id")
    @JsonPropertyDescription(value="Identifier for the project")
    public String projectId;
    @JsonProperty(value="dbms_id")
    @JsonPropertyDescription(value="Unique identifier for the DBMS")
    public String dbmsId;
    @JsonProperty(value="server_id")
    @JsonPropertyDescription(value="Unique identifier for the server")
    public String serverId;
    @JsonPropertyDescription(value="Map of metric names to lists of DataPoint objects. Values are dynamically populated from the Fleet Management server.")
    @ValuesDocumentation(valueSupplier=MetricNamesSupplier.class)
    public Map<String, List<DataPoint>> metrics;
}

