/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.communication.upstream;

import com.auth0.jwt.interfaces.ECDSAKeyProvider;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.util.Base64;

public class ApiKeyProvider
implements ECDSAKeyProvider {
    private final ApiKey key;

    public ApiKeyProvider(ApiKey key) {
        this.key = key;
    }

    @Override
    public ECPrivateKey getPrivateKey() {
        PrivateKey key;
        KeyFactory keyFactory;
        try {
            keyFactory = KeyFactory.getInstance("EC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            key = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(this.key.privateKey)));
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        return (ECPrivateKey)key;
    }

    @Override
    public String getPrivateKeyId() {
        return this.key.keyId;
    }

    @Override
    public ECPublicKey getPublicKeyById(String arg0) {
        return null;
    }

    public static class ApiKey {
        @JsonProperty(value="kid")
        String keyId;
        @JsonProperty(value="private_key")
        String privateKey;
        @JsonProperty(value="project_id")
        String projectId;
        @JsonProperty(value="expiry_time")
        String expiryTime;

        public String keyId() {
            return this.keyId;
        }

        public String privateKey() {
            return this.privateKey;
        }

        public String projectId() {
            return this.projectId;
        }

        public Instant expiryTime() {
            return Instant.parse(this.expiryTime);
        }
    }
}

