/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.communication.upstream;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.ECDSAKeyProvider;
import java.util.Date;
import java.util.UUID;

public class ApiTokenGenerator {
    private final ECDSAKeyProvider keyProvider;

    public ApiTokenGenerator(ECDSAKeyProvider kp) {
        this.keyProvider = kp;
    }

    public String generate(ApiTokenClaims claims) {
        Algorithm algorithm = Algorithm.ECDSA256(this.keyProvider);
        return JWT.create().withKeyId(this.keyProvider.getPrivateKeyId()).withIssuer(claims.issuer).withSubject(claims.subject).withClaim("project_id", claims.projectId).withClaim("dbms_id", claims.dbmsId).withAudience(claims.audience).withIssuedAt(new Date()).withExpiresAt(claims.expiresAt).withJWTId(UUID.randomUUID().toString()).sign(algorithm);
    }

    public static class ApiTokenClaims {
        String issuer;
        String subject;
        String audience;
        Date expiresAt;
        String projectId;
        String dbmsId;

        public ApiTokenClaims() {
        }

        public ApiTokenClaims(String issuer, String subject, String audience, Date expiresAt, String projectId, String dbmsId) {
            this.issuer = issuer;
            this.subject = subject;
            this.audience = audience;
            this.expiresAt = expiresAt;
            this.projectId = projectId;
            this.dbmsId = dbmsId;
        }
    }
}

