/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.metrics;

import com.neo4j.fleetmanagement.communication.model.DataPoint;
import com.neo4j.fleetmanagement.metrics.ICollector;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.List;
import java.util.Map;

public class CpuCollector
implements ICollector {
    private final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();

    @Override
    public void collect(Map<String, List<DataPoint>> data) {
        double quotient = this.operatingSystemMXBean.getSystemLoadAverage();
        data.put(MetricNames.CPU_USAGE.metricName, List.of(new DataPoint(quotient)));
        data.put(MetricNames.CPU_CORE_COUNT.metricName, List.of(new DataPoint(Runtime.getRuntime().availableProcessors())));
    }

    public static enum MetricNames {
        CPU_USAGE("fleet_management_cpu_usage"),
        CPU_CORE_COUNT("fleet_management_cpu_core_count");

        public final String metricName;

        private MetricNames(String metricName) {
            this.metricName = metricName;
        }
    }
}

