/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.metrics;

import com.neo4j.fleetmanagement.communication.model.DataPoint;
import com.neo4j.fleetmanagement.metrics.ICollector;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MemoryCollector
implements ICollector {
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    @Override
    public void collect(Map<String, List<DataPoint>> data) {
        long totalMemory;
        long heap = this.memoryMXBean.getHeapMemoryUsage().getUsed();
        long nonHeap = this.memoryMXBean.getNonHeapMemoryUsage().getUsed();
        long totalHeap = this.memoryMXBean.getHeapMemoryUsage().getMax();
        data.put(MetricNames.HEAP_USED.metricName, List.of(new DataPoint(heap)));
        data.put(MetricNames.NON_HEAP_USED.metricName, List.of(new DataPoint(nonHeap)));
        data.put(MetricNames.TOTAL_HEAP.metricName, List.of(new DataPoint(totalHeap)));
        long jvmMemory = Runtime.getRuntime().totalMemory();
        try {
            ObjectName osBean = new ObjectName("java.lang:type=OperatingSystem");
            Object attribute = this.mBeanServer.getAttribute(osBean, "TotalPhysicalMemorySize");
            totalMemory = Long.parseLong(attribute.toString());
        }
        catch (Exception e) {
            System.out.println("Error getting total physical memory: " + e.getMessage());
            totalMemory = jvmMemory;
        }
        long usedMemory = jvmMemory - Runtime.getRuntime().freeMemory();
        data.put(MetricNames.TOTAL_MEMORY.metricName, List.of(new DataPoint(totalMemory)));
        data.put(MetricNames.MEMORY_USED.metricName, List.of(new DataPoint(usedMemory)));
    }

    public static enum MetricNames {
        HEAP_USED("fleet_management_heap_used"),
        NON_HEAP_USED("fleet_management_non_heap_used"),
        TOTAL_HEAP("fleet_management_total_heap"),
        TOTAL_MEMORY("fleet_management_total_memory"),
        MEMORY_USED("fleet_management_memory_used");

        public final String metricName;

        private MetricNames(String metricName) {
            this.metricName = metricName;
        }
    }
}

