/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.topology;

import com.neo4j.fleetmanagement.configuration.Configuration;
import com.neo4j.fleetmanagement.utils.ObjectHandler;
import com.neo4j.fleetmanagement.utils.PatternCompiler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.configuration.Config;

public class Neo4jConfigMapper
implements PropertyChangeListener {
    private final Config config;
    private final Configuration configuration = Configuration.getInstance();
    private List<Pattern> neo4jConfigs;

    public Neo4jConfigMapper(Config config) {
        this.configuration.addPropertyChangeListener(this);
        this.config = config;
        this.neo4jConfigs = List.of();
        this.updateNeo4jConfigs(this.configuration.getNeo4jConfigKeyGlobs());
    }

    public Map<String, Object> mapConfig() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        this.config.getDeclaredSettings().forEach((name, setting) -> {
            if (this.neo4jConfigs.stream().noneMatch(pattern -> pattern.matcher((CharSequence)name).matches())) {
                return;
            }
            Object value = this.config.get(setting);
            if (value != null) {
                if (value instanceof List) {
                    value = ObjectHandler.handleList((List)value);
                } else if (value instanceof Map) {
                    value = ObjectHandler.handleMap((Map)value);
                } else if (!ObjectHandler.isBasicType(value)) {
                    value = value.toString();
                }
            }
            configMap.put((String)name, value);
        });
        return configMap;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("neo4jConfigs")) {
            this.updateNeo4jConfigs(this.configuration.getNeo4jConfigKeyGlobs());
        }
    }

    private void updateNeo4jConfigs(List<String> newNeo4jConfigs) {
        if (newNeo4jConfigs == null) {
            return;
        }
        this.neo4jConfigs = newNeo4jConfigs.stream().map(PatternCompiler::constructPattern).collect(Collectors.toList());
    }
}

