/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.topology.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.neo4j.fleetmanagement.topology.model.GraphCount;
import java.util.List;

public class Database {
    @JsonPropertyDescription(value="Name of the database")
    public String name;
    @JsonPropertyDescription(value="Role of the database in the cluster")
    public String role;
    @JsonPropertyDescription(value="Type of the database in the cluster")
    public String type;
    @JsonPropertyDescription(value="List of database aliases")
    public List<String> aliases;
    @JsonPropertyDescription(value="Access level of the database")
    public String access;
    @JsonPropertyDescription(value="Unique identifier for the database")
    public String databaseId;
    @JsonPropertyDescription(value="Requested status of the database")
    public String requestedStatus;
    @JsonPropertyDescription(value="Current status of the database")
    public String currentStatus;
    @JsonPropertyDescription(value="Status message describing the current state")
    public String statusMessage;
    @JsonProperty(value="default")
    @JsonPropertyDescription(value="Whether this is the default database")
    public boolean _default;
    @JsonPropertyDescription(value="Whether this is the home database")
    public boolean home;
    @JsonPropertyDescription(value="Current number of primaries for this database")
    public Integer currentPrimariesCount;
    @JsonPropertyDescription(value="Current number of secondaries for this database")
    public Integer currentSecondariesCount;
    @JsonPropertyDescription(value="Requested number of primaries for this database")
    public Integer requestedPrimariesCount;
    @JsonPropertyDescription(value="Requested number of secondaries for this database")
    public Integer requestedSecondariesCount;
    @JsonPropertyDescription(value="Timestamp when the database was created")
    public long creationTime;
    @JsonPropertyDescription(value="Timestamp when the database was last started")
    public long lastStartTime;
    @JsonPropertyDescription(value="Store format of the database")
    public String store;
    @JsonPropertyDescription(value="Whether this instance is a writer for this database")
    public boolean writer;
    @JsonPropertyDescription(value="Last committed transaction ID")
    public Integer lastCommittedTxn;
    @JsonPropertyDescription(value="Current replication lag")
    public Integer replicationLag;
    @JsonPropertyDescription(value="Current graph counts for the database")
    public GraphCount graphCount;
    @JsonPropertyDescription(value="List of graph shards of this database")
    public List<String> graphShards;
    @JsonPropertyDescription(value="List of property shards of this database")
    public List<String> propertyShards;

    @JsonIgnore
    public boolean isComposite() {
        return "composite".equalsIgnoreCase(this.type);
    }
}

