/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.transactions.editions;

import com.neo4j.fleetmanagement.common.CachedMethod;
import com.neo4j.fleetmanagement.common.TransactionUtil;
import com.neo4j.fleetmanagement.topology.model.Database;
import com.neo4j.fleetmanagement.topology.model.Server;
import com.neo4j.fleetmanagement.transactions.AbstractTransactor;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import com.neo4j.fleetmanagement.transactions.editions.Shared;
import com.neo4j.fleetmanagement.transactions.model.ResultMap;
import com.neo4j.fleetmanagement.transactions.model.SimpleSemver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Result;

public class v5_EnterpriseTransactor
extends AbstractTransactor
implements ITransactor {
    private final CachedMethod<Server.License> licenseCacheMethod = new CachedMethod();

    @Override
    public Map<String, Server> getServers() {
        return TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
            HashMap<String, Server> instanceMap = new HashMap<String, Server>();
            Result r = tx.execute("SHOW SERVERS YIELD name, state, serverId, address, health, modeConstraint, version");
            tx.commit();
            while (r.hasNext()) {
                ResultMap result = new ResultMap(r.next());
                Server server = new Server();
                server.serverId = result.getString("serverId");
                server.name = result.getString("name", null);
                server.address = result.getString("address", "unknown");
                server.health = result.getString("health");
                server.modeConstraint = result.getString("modeConstraint");
                server.version = result.getString("version", "unknown");
                server.state = result.getString("state", null);
                instanceMap.put(server.serverId, server);
            }
            return instanceMap;
        });
    }

    @Override
    public Map<String, List<Database>> getDatabases() {
        return TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
            HashMap<String, List> databasesByInstance = new HashMap<String, List>();
            Result r = tx.execute("SHOW DATABASES YIELD *");
            tx.commit();
            while (r.hasNext()) {
                ResultMap instanceDatabases = new ResultMap(r.next());
                String serverId = instanceDatabases.getString("serverID");
                List dbArray = databasesByInstance.computeIfAbsent(serverId, k -> new ArrayList());
                Database oneDb = Shared.getDatabaseWithSharedProps(instanceDatabases);
                Shared.addV5SpecificProps(oneDb, instanceDatabases);
                dbArray.add(oneDb);
            }
            return databasesByInstance;
        });
    }

    @Override
    public Server.License getLicense() {
        return this.licenseCacheMethod.GetCachedOrRun(() -> {
            SimpleSemver version = this.mustGetVersion();
            if (version.compareTo(new SimpleSemver("5.4.0")) < 0) {
                Server.License license = new Server.License();
                license.type = Server.License.LicenseType.UNSUPPORTED;
                license.state = Server.License.LicenseState.UNKNOWN;
                return license;
            }
            Server.License license = new Server.License();
            license.type = Server.License.LicenseType.COMMERCIAL;
            String status = version.compareTo(new SimpleSemver("5.7.0")) >= 0 ? TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
                Result r = tx.execute("CALL dbms.licenseAgreementDetails()");
                tx.commit();
                ResultMap result = new ResultMap(r.next());
                license.daysLeftOnTrial = result.getInteger("daysLeftOnTrial", null);
                license.totalTrialDays = result.getInteger("totalTrialDays", null);
                return result.getString("status");
            }) : TransactionUtil.withSystemTransaction(this.databaseManagementService, tx -> {
                Result r = tx.execute("CALL dbms.acceptedLicenseAgreement()");
                tx.commit();
                ResultMap result = new ResultMap(r.next());
                return result.getString("value");
            });
            switch (status) {
                case "yes": {
                    license.state = Server.License.LicenseState.VALID;
                    break;
                }
                case "no": {
                    license.state = Server.License.LicenseState.NOT_ACCEPTED;
                    license.type = Server.License.LicenseType.EVALUATION;
                    break;
                }
                case "expired": {
                    license.state = Server.License.LicenseState.EXPIRED;
                    license.type = Server.License.LicenseType.EVALUATION;
                    break;
                }
                case "eval": {
                    license.state = Server.License.LicenseState.VALID;
                    license.type = Server.License.LicenseType.EVALUATION;
                    break;
                }
                default: {
                    license.state = Server.License.LicenseState.UNKNOWN;
                }
            }
            return license;
        });
    }

    @Override
    public void setToken(String token) {
        super.setToken(token);
    }

    @Override
    public void rotateToken() {
        super.rotateToken();
    }

    @Override
    public void deleteToken() {
        super.deleteToken();
    }
}

