/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.lang.reflect.Array;
import java.lang.runtime.SwitchBootstraps;
import java.nio.CharBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.VectorExtractor;
import org.neo4j.graphdb.Vector;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.Float32Vector;
import org.neo4j.values.storable.Float64Vector;
import org.neo4j.values.storable.Int16Vector;
import org.neo4j.values.storable.Int32Vector;
import org.neo4j.values.storable.Int64Vector;
import org.neo4j.values.storable.Int8Vector;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.storable.VectorValue;

public final class Extractors {
    private final Map<String, Extractor<?>> instances = new HashMap();
    private final StringExtractor string;
    private final LongExtractor long_;
    private final IntExtractor int_;
    private final CharExtractor char_;
    private final ShortExtractor short_;
    private final ByteExtractor byte_;
    private final BooleanExtractor boolean_;
    private final FloatExtractor float_;
    private final DoubleExtractor double_;
    private final StringArrayExtractor stringArray;
    private final BooleanArrayExtractor booleanArray;
    private final ByteArrayExtractor byteArray;
    private final ShortArrayExtractor shortArray;
    private final IntArrayExtractor intArray;
    private final LongArrayExtractor longArray;
    private final FloatArrayExtractor floatArray;
    private final DoubleArrayExtractor doubleArray;
    private final PointExtractor point;
    private final PointArrayExtractor pointArray;
    private final DateExtractor date;
    private final DateArrayExtractor dateArray;
    private final TimeExtractor time;
    private final TimeArrayExtractor timeArray;
    private final DateTimeExtractor dateTime;
    private final DateTimeArrayExtractor dateTimeArray;
    private final LocalTimeExtractor localTime;
    private final LocalTimeArrayExtractor localTimeArray;
    private final LocalDateTimeExtractor localDateTime;
    private final LocalDateTimeArrayExtractor localDateTimeArray;
    private final DurationExtractor duration;
    private final TextValueExtractor textValue;
    private final DurationArrayExtractor durationArray;
    private final Int8VectorExtractor int8Vector;
    private final Int16VectorExtractor int16Vector;
    private final Int32VectorExtractor int32Vector;
    private final Int64VectorExtractor int64Vector;
    private final Float32VectorExtractor float32Vector;
    private final Float64VectorExtractor float64Vector;
    private static final char[] BOOLEAN_MATCH = new char[Boolean.TRUE.toString().length()];
    private static final Supplier<ZoneId> inUTC;
    private static final char[] BOOLEAN_TRUE_CHARACTERS;

    public Extractors() {
        this(';', ';');
    }

    public Extractors(char arrayDelimiter, char vectorDelimiter) {
        this(arrayDelimiter, vectorDelimiter, Configuration.COMMAS.emptyQuotedStringsAsNull(), Configuration.COMMAS.trimStrings(), inUTC);
    }

    public Extractors(char arrayDelimiter, char vectorDelimiter, boolean emptyStringsAsNull) {
        this(arrayDelimiter, vectorDelimiter, emptyStringsAsNull, Configuration.COMMAS.trimStrings(), inUTC);
    }

    public Extractors(char arrayDelimiter, char vectorDelimiter, boolean emptyStringsAsNull, boolean trimStrings) {
        this(arrayDelimiter, vectorDelimiter, emptyStringsAsNull, trimStrings, inUTC);
    }

    public Extractors(char arrayDelimiter, char vectorDelimiter, boolean emptyStringsAsNull, boolean trimStrings, Supplier<ZoneId> defaultTimeZone) {
        this.string = new StringExtractor(emptyStringsAsNull);
        this.add(this.string);
        this.long_ = new LongExtractor();
        this.add(this.long_);
        this.int_ = new IntExtractor(this.long_);
        this.add(this.int_);
        this.char_ = new CharExtractor(this.string);
        this.add(this.char_);
        this.short_ = new ShortExtractor(this.long_);
        this.add(this.short_);
        this.byte_ = new ByteExtractor(this.long_);
        this.add(this.byte_);
        this.boolean_ = new BooleanExtractor();
        this.add(this.boolean_);
        this.double_ = new DoubleExtractor();
        this.add(this.double_);
        this.float_ = new FloatExtractor(this.double_);
        this.add(this.float_);
        this.stringArray = new StringArrayExtractor(arrayDelimiter, trimStrings);
        this.add(this.stringArray);
        this.booleanArray = new BooleanArrayExtractor(arrayDelimiter);
        this.add(this.booleanArray);
        this.longArray = new LongArrayExtractor(arrayDelimiter);
        this.add(this.longArray);
        this.byteArray = new ByteArrayExtractor(arrayDelimiter);
        this.add(this.byteArray);
        this.shortArray = new ShortArrayExtractor(arrayDelimiter);
        this.add(this.shortArray);
        this.intArray = new IntArrayExtractor(arrayDelimiter);
        this.add(this.intArray);
        this.doubleArray = new DoubleArrayExtractor(arrayDelimiter);
        this.add(this.doubleArray);
        this.floatArray = new FloatArrayExtractor(arrayDelimiter);
        this.add(this.floatArray);
        this.point = new PointExtractor();
        this.add(this.point);
        this.pointArray = new PointArrayExtractor(arrayDelimiter);
        this.add(this.pointArray);
        this.date = new DateExtractor();
        this.add(this.date);
        this.dateArray = new DateArrayExtractor(arrayDelimiter);
        this.add(this.dateArray);
        this.time = new TimeExtractor(defaultTimeZone);
        this.add(this.time);
        this.timeArray = new TimeArrayExtractor(arrayDelimiter, defaultTimeZone);
        this.add(this.timeArray);
        this.dateTime = new DateTimeExtractor(defaultTimeZone);
        this.add(this.dateTime);
        this.dateTimeArray = new DateTimeArrayExtractor(arrayDelimiter, defaultTimeZone);
        this.add(this.dateTimeArray);
        this.localTime = new LocalTimeExtractor();
        this.add(this.localTime);
        this.localTimeArray = new LocalTimeArrayExtractor(arrayDelimiter);
        this.add(this.localTimeArray);
        this.localDateTime = new LocalDateTimeExtractor();
        this.add(this.localDateTime);
        this.localDateTimeArray = new LocalDateTimeArrayExtractor(arrayDelimiter);
        this.add(this.localDateTimeArray);
        this.duration = new DurationExtractor();
        this.add(this.duration);
        this.textValue = new TextValueExtractor(emptyStringsAsNull);
        this.add(this.textValue);
        this.durationArray = new DurationArrayExtractor(arrayDelimiter);
        this.add(this.durationArray);
        this.int8Vector = new Int8VectorExtractor(vectorDelimiter);
        this.add(this.int8Vector);
        this.int16Vector = new Int16VectorExtractor(vectorDelimiter);
        this.add(this.int16Vector);
        this.int32Vector = new Int32VectorExtractor(vectorDelimiter);
        this.add(this.int32Vector);
        this.int64Vector = new Int64VectorExtractor(vectorDelimiter);
        this.add(this.int64Vector);
        this.float32Vector = new Float32VectorExtractor(vectorDelimiter);
        this.add(this.float32Vector);
        this.float64Vector = new Float64VectorExtractor(vectorDelimiter);
        this.add(this.float64Vector);
    }

    public void add(Extractor<?> extractor) {
        this.instances.put(extractor.name().toUpperCase(Locale.ROOT), extractor);
    }

    public Extractor<?> valueOf(String name, CSVHeaderInformation optionalParameter) {
        Extractor<?> instance;
        String upperCaseName = name.toUpperCase(Locale.ROOT);
        Extractor<?> extractor = instance = "VECTOR".equals(upperCaseName) ? this.getVectorExtractor(optionalParameter) : this.instances.get(upperCaseName);
        if (instance == null) {
            throw new IllegalArgumentException("'" + name + "' is not a valid type.");
        }
        return instance;
    }

    private Extractor<?> getVectorExtractor(CSVHeaderInformation optionalParameter) {
        CSVHeaderInformation cSVHeaderInformation = optionalParameter;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VectorExtractor.VectorCSVHeaderInformation.class}, (Object)cSVHeaderInformation, n)) {
            case 0: {
                VectorExtractor.VectorCSVHeaderInformation vectorCSVHeaderInformation = (VectorExtractor.VectorCSVHeaderInformation)cSVHeaderInformation;
                Extractor<?> baseExtractor = switch (vectorCSVHeaderInformation.getCoordinateType()) {
                    default -> throw new MatchException(null, null);
                    case Vector.CoordinateType.INTEGER8 -> this.instances.get("Int8Vector".toUpperCase(Locale.ROOT));
                    case Vector.CoordinateType.INTEGER16 -> this.instances.get("Int16Vector".toUpperCase(Locale.ROOT));
                    case Vector.CoordinateType.INTEGER32 -> this.instances.get("Int32Vector".toUpperCase(Locale.ROOT));
                    case Vector.CoordinateType.INTEGER64 -> this.instances.get("Int64Vector".toUpperCase(Locale.ROOT));
                    case Vector.CoordinateType.FLOAT32 -> this.instances.get("Float32Vector".toUpperCase(Locale.ROOT));
                    case Vector.CoordinateType.FLOAT64 -> this.instances.get("Float64Vector".toUpperCase(Locale.ROOT));
                };
                return ((VectorExtractor)baseExtractor).getDimensionVerifyingExtractor(vectorCSVHeaderInformation.getDimensions());
            }
            case -1: {
                throw new IllegalArgumentException("vector must specify dimensions and coordinate type, e.g.\"v:vector{dimensions:10, coordinateType:byte}\"");
            }
        }
        throw new IllegalStateException("Wrong header information type: " + String.valueOf(optionalParameter));
    }

    public Extractor<String> string() {
        return this.string;
    }

    public Extractor<Long> long_() {
        return this.long_;
    }

    public Extractor<Integer> int_() {
        return this.int_;
    }

    public Extractor<Character> char_() {
        return this.char_;
    }

    public Extractor<Short> short_() {
        return this.short_;
    }

    public Extractor<Byte> byte_() {
        return this.byte_;
    }

    public Extractor<Boolean> boolean_() {
        return this.boolean_;
    }

    public Extractor<Float> float_() {
        return this.float_;
    }

    public Extractor<Double> double_() {
        return this.double_;
    }

    public Extractor<String[]> stringArray() {
        return this.stringArray;
    }

    public Extractor<boolean[]> booleanArray() {
        return this.booleanArray;
    }

    public Extractor<byte[]> byteArray() {
        return this.byteArray;
    }

    public Extractor<short[]> shortArray() {
        return this.shortArray;
    }

    public Extractor<int[]> intArray() {
        return this.intArray;
    }

    public Extractor<long[]> longArray() {
        return this.longArray;
    }

    public Extractor<float[]> floatArray() {
        return this.floatArray;
    }

    public Extractor<double[]> doubleArray() {
        return this.doubleArray;
    }

    public Extractor<PointValue> point() {
        return this.point;
    }

    public Extractor<PointArray> pointArray() {
        return this.pointArray;
    }

    public Extractor<DateValue> date() {
        return this.date;
    }

    public Extractor<DateArray> dateArray() {
        return this.dateArray;
    }

    public Extractor<TimeValue> time() {
        return this.time;
    }

    public Extractor<TimeArray> timeArray() {
        return this.timeArray;
    }

    public Extractor<DateTimeValue> dateTime() {
        return this.dateTime;
    }

    public Extractor<DateTimeArray> dateTimeArray() {
        return this.dateTimeArray;
    }

    public Extractor<LocalTimeValue> localTime() {
        return this.localTime;
    }

    public Extractor<LocalTimeArray> localTimeArray() {
        return this.localTimeArray;
    }

    public Extractor<LocalDateTimeValue> localDateTime() {
        return this.localDateTime;
    }

    public Extractor<LocalDateTimeArray> localDateTimeArray() {
        return this.localDateTimeArray;
    }

    public Extractor<DurationValue> duration() {
        return this.duration;
    }

    public Extractor<Value> textValue() {
        return this.textValue;
    }

    public Extractor<DurationArray> durationArray() {
        return this.durationArray;
    }

    public Extractor<Int8Vector> int8Vector() {
        return this.int8Vector;
    }

    public Extractor<Int16Vector> int16Vector() {
        return this.int16Vector;
    }

    public Extractor<Int32Vector> int32Vector() {
        return this.int32Vector;
    }

    public Extractor<Int64Vector> int64Vector() {
        return this.int64Vector;
    }

    public Extractor<Float32Vector> float32Vector() {
        return this.float32Vector;
    }

    public Extractor<Float64Vector> float64Vector() {
        return this.float64Vector;
    }

    private static long extractLong(char[] data, int originalOffset, int fullLength) {
        int length;
        long result = 0L;
        boolean negate = false;
        int offset = originalOffset;
        for (length = fullLength; length > 0 && Character.isWhitespace(data[offset]); --length) {
            ++offset;
        }
        while (length > 0 && Character.isWhitespace(data[offset + length - 1])) {
            --length;
        }
        if (length > 0 && data[offset] == '-') {
            negate = true;
            ++offset;
            --length;
        }
        if (length < 1) {
            throw new NumberFormatException("Not an integer: \"" + String.valueOf(data, originalOffset, fullLength) + "\"");
        }
        try {
            for (int i = 0; i < length; ++i) {
                result = result * 10L + (long)Extractors.digit(data[offset + i]);
            }
        }
        catch (NumberFormatException ignored) {
            throw new NumberFormatException("Not an integer: \"" + String.valueOf(data, originalOffset, fullLength) + "\"");
        }
        return negate ? -result : result;
    }

    private static int digit(char ch) {
        int digit = ch - 48;
        if (digit < 0 || digit > 9) {
            throw new NumberFormatException();
        }
        return digit;
    }

    private static boolean extractBoolean(char[] data, int originalOffset, int fullLength) {
        int length;
        int offset = originalOffset;
        for (length = fullLength; length > 0 && Character.isWhitespace(data[offset]); --length) {
            ++offset;
        }
        while (length > 0 && Character.isWhitespace(data[offset + length - 1])) {
            --length;
        }
        if (length != BOOLEAN_TRUE_CHARACTERS.length) {
            return false;
        }
        for (int i = 0; i < BOOLEAN_TRUE_CHARACTERS.length && i < length; ++i) {
            if (data[offset + i] == BOOLEAN_TRUE_CHARACTERS[i]) continue;
            return false;
        }
        return true;
    }

    static {
        Boolean.TRUE.toString().getChars(0, BOOLEAN_MATCH.length, BOOLEAN_MATCH, 0);
        inUTC = () -> ZoneOffset.UTC;
        BOOLEAN_TRUE_CHARACTERS = new char[Boolean.TRUE.toString().length()];
        Boolean.TRUE.toString().getChars(0, BOOLEAN_TRUE_CHARACTERS.length, BOOLEAN_TRUE_CHARACTERS, 0);
    }

    private static final class StringExtractor
    extends AbstractExtractor<String> {
        private final boolean emptyStringsAsNull;

        public StringExtractor(boolean emptyStringsAsNull) {
            super(String.class.getSimpleName());
            this.emptyStringsAsNull = emptyStringsAsNull;
        }

        @Override
        public String extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0 && (!hadQuotes || this.emptyStringsAsNull)) {
                return null;
            }
            return new String(data, offset, length);
        }
    }

    private static final class LongExtractor
    extends AbstractExtractor<Long> {
        LongExtractor() {
            super(Long.TYPE.getSimpleName());
        }

        @Override
        public Long extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            return length == 0 ? null : Long.valueOf(Extractors.extractLong(data, offset, length));
        }
    }

    private static final class IntExtractor
    extends AbstractExtractor<Integer> {
        IntExtractor(LongExtractor longExtractor) {
            super(Integer.TYPE.getSimpleName(), longExtractor);
        }

        @Override
        public Integer extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            return length == 0 ? null : Integer.valueOf(Numbers.safeCastLongToInt((long)Extractors.extractLong(data, offset, length)));
        }
    }

    private static final class CharExtractor
    extends AbstractExtractor<Character> {
        CharExtractor(StringExtractor stringExtractor) {
            super(Character.TYPE.getSimpleName(), stringExtractor);
        }

        @Override
        public Character extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length > 1) {
                throw new IllegalStateException("Was told to extract a character, but length:" + length);
            }
            return length == 0 ? null : Character.valueOf(data[offset]);
        }
    }

    private static final class ShortExtractor
    extends AbstractExtractor<Short> {
        ShortExtractor(LongExtractor longExtractor) {
            super(Short.TYPE.getSimpleName(), longExtractor);
        }

        @Override
        public Short extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            return length == 0 ? null : Short.valueOf(Numbers.safeCastLongToShort((long)Extractors.extractLong(data, offset, length)));
        }
    }

    private static final class ByteExtractor
    extends AbstractExtractor<Byte> {
        ByteExtractor(LongExtractor longExtractor) {
            super(Byte.TYPE.getSimpleName(), longExtractor);
        }

        @Override
        public Byte extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            return length == 0 ? null : Byte.valueOf(Numbers.safeCastLongToByte((long)Extractors.extractLong(data, offset, length)));
        }
    }

    private static final class BooleanExtractor
    extends AbstractExtractor<Boolean> {
        BooleanExtractor() {
            super(Boolean.TYPE.getSimpleName());
        }

        @Override
        public Boolean extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            return length == 0 ? null : Boolean.valueOf(Extractors.extractBoolean(data, offset, length));
        }
    }

    private static final class DoubleExtractor
    extends AbstractExtractor<Double> {
        DoubleExtractor() {
            super(Double.TYPE.getSimpleName());
        }

        @Override
        public Double extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            try {
                return Double.parseDouble(String.valueOf(data, offset, length));
            }
            catch (NumberFormatException ignored) {
                throw new NumberFormatException("Not a number: \"" + String.valueOf(data, offset, length) + "\"");
            }
        }
    }

    private static final class FloatExtractor
    extends AbstractExtractor<Float> {
        FloatExtractor(DoubleExtractor doubleExtractor) {
            super(Float.TYPE.getSimpleName(), doubleExtractor);
        }

        @Override
        public Float extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            try {
                return Float.valueOf(Float.parseFloat(String.valueOf(data, offset, length)));
            }
            catch (NumberFormatException ignored) {
                throw new NumberFormatException("Not a number: \"" + String.valueOf(data, offset, length) + "\"");
            }
        }
    }

    private static final class StringArrayExtractor
    extends ArrayExtractor<String[], String[]> {
        private final boolean trimStrings;

        StringArrayExtractor(char arrayDelimiter, boolean trimStrings) {
            super(arrayDelimiter, String[].class);
            this.trimStrings = trimStrings;
        }

        @Override
        protected String[] emptyElement() {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }

        @Override
        protected String[] createInternalArray(int size) {
            return new String[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, String[] dest, int destIndex) {
            String value = new String(data, offset + charIndex, numberOfChars);
            if (this.trimStrings) {
                value = value.trim();
            }
            dest[destIndex] = value;
        }

        @Override
        protected String[] convertListToArrayValue(String[] values) {
            return values;
        }
    }

    private static final class BooleanArrayExtractor
    extends ArrayExtractor<boolean[], boolean[]> {
        BooleanArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, boolean[].class);
        }

        @Override
        protected boolean[] emptyElement() {
            return ArrayUtils.EMPTY_BOOLEAN_ARRAY;
        }

        @Override
        protected boolean[] createInternalArray(int size) {
            return new boolean[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, boolean[] dest, int destIndex) {
            dest[destIndex] = Extractors.extractBoolean(data, offset + charIndex, numberOfChars);
        }

        @Override
        protected boolean[] convertListToArrayValue(boolean[] values) {
            return values;
        }
    }

    private static final class LongArrayExtractor
    extends ArrayExtractor<long[], long[]> {
        LongArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, long[].class);
        }

        @Override
        protected long[] emptyElement() {
            return ArrayUtils.EMPTY_LONG_ARRAY;
        }

        @Override
        protected long[] createInternalArray(int size) {
            return new long[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, long[] dest, int destIndex) {
            dest[destIndex] = Extractors.extractLong(data, offset + charIndex, numberOfChars);
        }

        @Override
        protected long[] convertListToArrayValue(long[] values) {
            return values;
        }
    }

    private static final class ByteArrayExtractor
    extends ArrayExtractor<byte[], byte[]> {
        ByteArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, byte[].class);
        }

        @Override
        protected byte[] emptyElement() {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }

        @Override
        protected byte[] createInternalArray(int size) {
            return new byte[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, byte[] dest, int destIndex) {
            dest[destIndex] = Numbers.safeCastLongToByte((long)Extractors.extractLong(data, offset + charIndex, numberOfChars));
        }

        @Override
        protected byte[] convertListToArrayValue(byte[] values) {
            return values;
        }
    }

    private static final class ShortArrayExtractor
    extends ArrayExtractor<short[], short[]> {
        ShortArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, short[].class);
        }

        @Override
        protected short[] emptyElement() {
            return ArrayUtils.EMPTY_SHORT_ARRAY;
        }

        @Override
        protected short[] createInternalArray(int size) {
            return new short[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, short[] dest, int destIndex) {
            dest[destIndex] = Numbers.safeCastLongToShort((long)Extractors.extractLong(data, offset + charIndex, numberOfChars));
        }

        @Override
        protected short[] convertListToArrayValue(short[] values) {
            return values;
        }
    }

    private static final class IntArrayExtractor
    extends ArrayExtractor<int[], int[]> {
        IntArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, int[].class);
        }

        @Override
        protected int[] emptyElement() {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }

        @Override
        protected int[] createInternalArray(int size) {
            return new int[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, int[] dest, int destIndex) {
            dest[destIndex] = Numbers.safeCastLongToInt((long)Extractors.extractLong(data, offset + charIndex, numberOfChars));
        }

        @Override
        protected int[] convertListToArrayValue(int[] values) {
            return values;
        }
    }

    private static final class DoubleArrayExtractor
    extends ArrayExtractor<double[], double[]> {
        DoubleArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, double[].class);
        }

        @Override
        protected double[] emptyElement() {
            return ArrayUtils.EMPTY_DOUBLE_ARRAY;
        }

        @Override
        protected double[] createInternalArray(int size) {
            return new double[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, double[] dest, int destIndex) {
            dest[destIndex] = Double.parseDouble(String.valueOf(data, offset + charIndex, numberOfChars));
        }

        @Override
        protected double[] convertListToArrayValue(double[] values) {
            return values;
        }
    }

    private static final class FloatArrayExtractor
    extends ArrayExtractor<float[], float[]> {
        FloatArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, float[].class);
        }

        @Override
        protected float[] emptyElement() {
            return ArrayUtils.EMPTY_FLOAT_ARRAY;
        }

        @Override
        protected float[] createInternalArray(int size) {
            return new float[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, float[] dest, int destIndex) {
            dest[destIndex] = Float.parseFloat(String.valueOf(data, offset + charIndex, numberOfChars));
        }

        @Override
        protected float[] convertListToArrayValue(float[] values) {
            return values;
        }
    }

    private static final class PointExtractor
    extends AbstractExtractor<PointValue> {
        public static final String NAME = "Point";

        PointExtractor() {
            super(NAME);
        }

        @Override
        public PointValue extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            return PointValue.parse((CharSequence)CharBuffer.wrap(data, offset, length), (CSVHeaderInformation)optionalData);
        }
    }

    private static final class PointArrayExtractor
    extends ArrayAnyValueExtractor<PointValue[], PointArray> {
        private static final PointArray EMPTY = Values.pointArray((Point[])new Point[0]);

        PointArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "Point");
        }

        @Override
        protected PointArray emptyElement() {
            return EMPTY;
        }

        @Override
        protected PointValue[] createInternalArray(int size) {
            return new PointValue[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, PointValue[] dest, int destIndex) {
            dest[destIndex] = PointValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars), (CSVHeaderInformation)optionalData);
        }

        @Override
        protected PointArray convertListToArrayValue(PointValue[] values) {
            return Values.pointArray((PointValue[])values);
        }
    }

    private static final class DateExtractor
    extends AbstractExtractor<DateValue> {
        public static final String NAME = "Date";

        DateExtractor() {
            super(NAME);
        }

        @Override
        public DateValue extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            return DateValue.parse((CharSequence)CharBuffer.wrap(data, offset, length));
        }
    }

    private static final class DateArrayExtractor
    extends ArrayAnyValueExtractor<LocalDate[], DateArray> {
        private static final DateArray EMPTY = Values.dateArray((LocalDate[])new LocalDate[0]);

        DateArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "Date");
        }

        @Override
        protected DateArray emptyElement() {
            return EMPTY;
        }

        @Override
        protected LocalDate[] createInternalArray(int size) {
            return new LocalDate[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, LocalDate[] dest, int destIndex) {
            dest[destIndex] = (LocalDate)DateValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars)).asObjectCopy();
        }

        @Override
        protected DateArray convertListToArrayValue(LocalDate[] values) {
            return Values.dateArray((LocalDate[])values);
        }
    }

    private static final class TimeExtractor
    extends AbstractExtractor<TimeValue> {
        public static final String NAME = "Time";
        private final Supplier<ZoneId> defaultTimeZone;

        TimeExtractor(Supplier<ZoneId> defaultTimeZone) {
            super(NAME);
            this.defaultTimeZone = defaultTimeZone;
        }

        @Override
        public TimeValue extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            return TimeValue.parse((CharSequence)CharBuffer.wrap(data, offset, length), this.defaultTimeZone, (CSVHeaderInformation)optionalData);
        }
    }

    private static final class TimeArrayExtractor
    extends ArrayAnyValueExtractor<OffsetTime[], TimeArray> {
        private static final TimeArray EMPTY = Values.timeArray((OffsetTime[])new OffsetTime[0]);
        private final Supplier<ZoneId> defaultTimeZone;

        TimeArrayExtractor(char arrayDelimiter, Supplier<ZoneId> defaultTimeZone) {
            super(arrayDelimiter, "Time");
            this.defaultTimeZone = defaultTimeZone;
        }

        @Override
        protected TimeArray emptyElement() {
            return EMPTY;
        }

        @Override
        protected OffsetTime[] createInternalArray(int size) {
            return new OffsetTime[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, OffsetTime[] dest, int destIndex) {
            dest[destIndex] = (OffsetTime)TimeValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars), this.defaultTimeZone, (CSVHeaderInformation)optionalData).asObjectCopy();
        }

        @Override
        protected TimeArray convertListToArrayValue(OffsetTime[] values) {
            return Values.timeArray((OffsetTime[])values);
        }
    }

    private static final class DateTimeExtractor
    extends AbstractExtractor<DateTimeValue> {
        public static final String NAME = "DateTime";
        private final Supplier<ZoneId> defaultTimeZone;

        DateTimeExtractor(Supplier<ZoneId> defaultTimeZone) {
            super(NAME);
            this.defaultTimeZone = defaultTimeZone;
        }

        @Override
        public DateTimeValue extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            return DateTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset, length), this.defaultTimeZone, (CSVHeaderInformation)optionalData);
        }
    }

    private static final class DateTimeArrayExtractor
    extends ArrayAnyValueExtractor<ZonedDateTime[], DateTimeArray> {
        private static final DateTimeArray EMPTY = Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[0]);
        private final Supplier<ZoneId> defaultTimeZone;

        DateTimeArrayExtractor(char arrayDelimiter, Supplier<ZoneId> defaultTimeZone) {
            super(arrayDelimiter, "DateTime");
            this.defaultTimeZone = defaultTimeZone;
        }

        @Override
        protected DateTimeArray emptyElement() {
            return EMPTY;
        }

        @Override
        protected ZonedDateTime[] createInternalArray(int size) {
            return new ZonedDateTime[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, ZonedDateTime[] dest, int destIndex) {
            dest[destIndex] = (ZonedDateTime)DateTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars), this.defaultTimeZone, (CSVHeaderInformation)optionalData).asObjectCopy();
        }

        @Override
        protected DateTimeArray convertListToArrayValue(ZonedDateTime[] values) {
            return Values.dateTimeArray((ZonedDateTime[])values);
        }
    }

    private static final class LocalTimeExtractor
    extends AbstractExtractor<LocalTimeValue> {
        public static final String NAME = "LocalTime";

        LocalTimeExtractor() {
            super(NAME);
        }

        @Override
        public LocalTimeValue extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            return LocalTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset, length));
        }
    }

    private static final class LocalTimeArrayExtractor
    extends ArrayAnyValueExtractor<LocalTime[], LocalTimeArray> {
        private static final LocalTimeArray EMPTY = Values.localTimeArray((LocalTime[])new LocalTime[0]);

        LocalTimeArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "LocalTime");
        }

        @Override
        protected LocalTimeArray emptyElement() {
            return EMPTY;
        }

        @Override
        protected LocalTime[] createInternalArray(int size) {
            return new LocalTime[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, LocalTime[] dest, int destIndex) {
            dest[destIndex] = (LocalTime)LocalTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars)).asObjectCopy();
        }

        @Override
        protected LocalTimeArray convertListToArrayValue(LocalTime[] values) {
            return Values.localTimeArray((LocalTime[])values);
        }
    }

    private static final class LocalDateTimeExtractor
    extends AbstractExtractor<LocalDateTimeValue> {
        public static final String NAME = "LocalDateTime";

        LocalDateTimeExtractor() {
            super(NAME);
        }

        @Override
        public LocalDateTimeValue extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            return LocalDateTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset, length));
        }
    }

    private static final class LocalDateTimeArrayExtractor
    extends ArrayAnyValueExtractor<LocalDateTime[], LocalDateTimeArray> {
        private static final LocalDateTimeArray EMPTY = Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[0]);

        LocalDateTimeArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "LocalDateTime");
        }

        @Override
        protected LocalDateTimeArray emptyElement() {
            return EMPTY;
        }

        @Override
        protected LocalDateTime[] createInternalArray(int size) {
            return new LocalDateTime[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, LocalDateTime[] dest, int destIndex) {
            dest[destIndex] = (LocalDateTime)LocalDateTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars)).asObjectCopy();
        }

        @Override
        protected LocalDateTimeArray convertListToArrayValue(LocalDateTime[] values) {
            return Values.localDateTimeArray((LocalDateTime[])values);
        }
    }

    private static final class DurationExtractor
    extends AbstractExtractor<DurationValue> {
        public static final String NAME = "Duration";

        DurationExtractor() {
            super(NAME);
        }

        @Override
        public DurationValue extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0) {
                return null;
            }
            return DurationValue.parse((CharSequence)CharBuffer.wrap(data, offset, length));
        }
    }

    private static final class TextValueExtractor
    extends AbstractExtractor<Value> {
        public static final String NAME = "TextValue";
        private final boolean emptyStringsAsNull;

        TextValueExtractor(boolean emptyStringsAsNull) {
            super(NAME);
            this.emptyStringsAsNull = emptyStringsAsNull;
        }

        @Override
        public Value extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (length == 0 && (!hadQuotes || this.emptyStringsAsNull)) {
                return Values.NO_VALUE;
            }
            return Values.utf8Value((String)new String(data, offset, length));
        }
    }

    private static final class DurationArrayExtractor
    extends ArrayAnyValueExtractor<DurationValue[], DurationArray> {
        private static final DurationArray EMPTY = Values.durationArray((DurationValue[])new DurationValue[0]);

        DurationArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "Duration");
        }

        @Override
        protected DurationArray emptyElement() {
            return EMPTY;
        }

        @Override
        protected DurationValue[] createInternalArray(int size) {
            return new DurationValue[size];
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, DurationValue[] dest, int destIndex) {
            dest[destIndex] = DurationValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars));
        }

        @Override
        protected DurationArray convertListToArrayValue(DurationValue[] values) {
            return Values.durationArray((DurationValue[])values);
        }
    }

    private static final class Int8VectorExtractor
    extends ArrayExtractor<byte[], Int8Vector>
    implements VectorExtractor<Int8Vector> {
        public static final String NAME = "Int8Vector";

        Int8VectorExtractor(char vectorDelimiter) {
            super(vectorDelimiter, NAME, null);
        }

        @Override
        public Extractor<Int8Vector> getDimensionVerifyingExtractor(int expectedDimensions) {
            return new DimensionVerifyingVectorExtractorWrapper<byte[], Int8Vector>(this, expectedDimensions);
        }

        @Override
        protected Int8Vector emptyElement() {
            return null;
        }

        @Override
        protected byte[] createInternalArray(int size) {
            return new byte[size];
        }

        @Override
        public boolean isEmpty(Object value) {
            return VectorExtractor.super.isEmpty(value);
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, byte[] dest, int destIndex) {
            dest[destIndex] = Numbers.safeCastLongToByte((long)Extractors.extractLong(data, offset + charIndex, numberOfChars));
        }

        @Override
        protected Int8Vector convertListToArrayValue(byte[] values) {
            return Values.int8Vector((byte[])values);
        }
    }

    private static final class Int16VectorExtractor
    extends ArrayExtractor<short[], Int16Vector>
    implements VectorExtractor<Int16Vector> {
        public static final String NAME = "Int16Vector";

        Int16VectorExtractor(char vectorDelimiter) {
            super(vectorDelimiter, NAME, null);
        }

        @Override
        public Extractor<Int16Vector> getDimensionVerifyingExtractor(int expectedDimensions) {
            return new DimensionVerifyingVectorExtractorWrapper<short[], Int16Vector>(this, expectedDimensions);
        }

        @Override
        protected Int16Vector emptyElement() {
            return null;
        }

        @Override
        protected short[] createInternalArray(int size) {
            return new short[size];
        }

        @Override
        public boolean isEmpty(Object value) {
            return VectorExtractor.super.isEmpty(value);
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, short[] dest, int destIndex) {
            dest[destIndex] = Numbers.safeCastLongToShort((long)Extractors.extractLong(data, offset + charIndex, numberOfChars));
        }

        @Override
        protected Int16Vector convertListToArrayValue(short[] values) {
            return Values.int16Vector((short[])values);
        }
    }

    private static final class Int32VectorExtractor
    extends ArrayExtractor<int[], Int32Vector>
    implements VectorExtractor<Int32Vector> {
        public static final String NAME = "Int32Vector";

        Int32VectorExtractor(char vectorDelimiter) {
            super(vectorDelimiter, NAME, null);
        }

        @Override
        public Extractor<Int32Vector> getDimensionVerifyingExtractor(int expectedDimensions) {
            return new DimensionVerifyingVectorExtractorWrapper<int[], Int32Vector>(this, expectedDimensions);
        }

        @Override
        protected Int32Vector emptyElement() {
            return null;
        }

        @Override
        protected int[] createInternalArray(int size) {
            return new int[size];
        }

        @Override
        public boolean isEmpty(Object value) {
            return VectorExtractor.super.isEmpty(value);
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, int[] dest, int destIndex) {
            dest[destIndex] = Numbers.safeCastLongToInt((long)Extractors.extractLong(data, offset + charIndex, numberOfChars));
        }

        @Override
        protected Int32Vector convertListToArrayValue(int[] values) {
            return Values.int32Vector((int[])values);
        }
    }

    private static final class Int64VectorExtractor
    extends ArrayExtractor<long[], Int64Vector>
    implements VectorExtractor<Int64Vector> {
        public static final String NAME = "Int64Vector";

        Int64VectorExtractor(char vectorDelimiter) {
            super(vectorDelimiter, NAME, null);
        }

        @Override
        public Extractor<Int64Vector> getDimensionVerifyingExtractor(int expectedDimensions) {
            return new DimensionVerifyingVectorExtractorWrapper<long[], Int64Vector>(this, expectedDimensions);
        }

        @Override
        protected Int64Vector emptyElement() {
            return null;
        }

        @Override
        protected long[] createInternalArray(int size) {
            return new long[size];
        }

        @Override
        public boolean isEmpty(Object value) {
            return VectorExtractor.super.isEmpty(value);
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, long[] dest, int destIndex) {
            dest[destIndex] = Extractors.extractLong(data, offset + charIndex, numberOfChars);
        }

        @Override
        protected Int64Vector convertListToArrayValue(long[] values) {
            return Values.int64Vector((long[])values);
        }
    }

    private static final class Float32VectorExtractor
    extends ArrayExtractor<float[], Float32Vector>
    implements VectorExtractor<Float32Vector> {
        public static final String NAME = "Float32Vector";

        Float32VectorExtractor(char vectorDelimiter) {
            super(vectorDelimiter, NAME, null);
        }

        @Override
        public Extractor<Float32Vector> getDimensionVerifyingExtractor(int expectedDimensions) {
            return new DimensionVerifyingVectorExtractorWrapper<float[], Float32Vector>(this, expectedDimensions);
        }

        @Override
        protected Float32Vector emptyElement() {
            return null;
        }

        @Override
        protected float[] createInternalArray(int size) {
            return new float[size];
        }

        @Override
        public boolean isEmpty(Object value) {
            return VectorExtractor.super.isEmpty(value);
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, float[] dest, int destIndex) {
            dest[destIndex] = Float.parseFloat(String.valueOf(data, offset + charIndex, numberOfChars));
        }

        @Override
        protected Float32Vector convertListToArrayValue(float[] values) {
            return Values.float32Vector((float[])values);
        }
    }

    private static final class Float64VectorExtractor
    extends ArrayExtractor<double[], Float64Vector>
    implements VectorExtractor<Float64Vector> {
        public static final String NAME = "Float64Vector";

        Float64VectorExtractor(char vectorDelimiter) {
            super(vectorDelimiter, NAME, null);
        }

        @Override
        public Extractor<Float64Vector> getDimensionVerifyingExtractor(int expectedDimensions) {
            return new DimensionVerifyingVectorExtractorWrapper<double[], Float64Vector>(this, expectedDimensions);
        }

        @Override
        protected Float64Vector emptyElement() {
            return null;
        }

        @Override
        protected double[] createInternalArray(int size) {
            return new double[size];
        }

        @Override
        public boolean isEmpty(Object value) {
            return VectorExtractor.super.isEmpty(value);
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, double[] dest, int destIndex) {
            dest[destIndex] = Double.parseDouble(String.valueOf(data, offset + charIndex, numberOfChars));
        }

        @Override
        protected Float64Vector convertListToArrayValue(double[] values) {
            return Values.float64Vector((double[])values);
        }
    }

    private static abstract class ArrayAnyValueExtractor<E, T extends ArrayValue>
    extends ArrayExtractor<E, T> {
        ArrayAnyValueExtractor(char arrayDelimiter, String valueTypeName) {
            super(arrayDelimiter, valueTypeName + "[]", null);
        }

        @Override
        public boolean isEmpty(Object value) {
            return super.isEmpty(value) || ((ArrayValue)value).isEmpty();
        }
    }

    private static final class DimensionVerifyingVectorExtractorWrapper<E, T extends VectorValue>
    extends ArrayExtractor<E, T> {
        private final ArrayExtractor<E, T> delegate;
        private final int expectedDimensions;

        DimensionVerifyingVectorExtractorWrapper(ArrayExtractor<E, T> delegate, int expectedDimensions) {
            super(delegate.arrayDelimiter, delegate.name(), null);
            this.delegate = delegate;
            this.expectedDimensions = expectedDimensions;
        }

        @Override
        protected T emptyElement() {
            return (T)((VectorValue)this.delegate.emptyElement());
        }

        @Override
        protected E createInternalArray(int size) {
            return this.delegate.createInternalArray(size);
        }

        @Override
        protected void parseAndStoreElement(char[] data, int offset, int charIndex, int numberOfChars, CSVHeaderInformation optionalData, E dest, int destIndex) {
            this.delegate.parseAndStoreElement(data, offset, charIndex, numberOfChars, optionalData, dest, destIndex);
        }

        @Override
        protected T convertListToArrayValue(E values) {
            VectorValue vectorValue = (VectorValue)this.delegate.convertListToArrayValue(values);
            if (vectorValue.dimensions() != this.expectedDimensions) {
                throw new IllegalArgumentException("Header specified %d dimensions, but vector has %d dimensions: %s".formatted(this.expectedDimensions, vectorValue.dimensions(), vectorValue));
            }
            return (T)vectorValue;
        }

        @Override
        public boolean isEmpty(Object value) {
            return this.delegate.isEmpty(value);
        }
    }

    private static abstract class ArrayExtractor<E, T>
    extends AbstractExtractor<T> {
        protected final char arrayDelimiter;

        ArrayExtractor(char arrayDelimiter, Class<T> arrayType) {
            this(arrayDelimiter, arrayType, null);
        }

        ArrayExtractor(char arrayDelimiter, Class<T> arrayType, Extractor<?> normalizedExtractor) {
            this(arrayDelimiter, arrayType.getSimpleName(), normalizedExtractor);
        }

        ArrayExtractor(char arrayDelimiter, String componentTypeName, Extractor<?> normalizedExtractor) {
            super(componentTypeName, normalizedExtractor);
            this.arrayDelimiter = arrayDelimiter;
        }

        @Override
        public final T extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                return this.emptyElement();
            }
            E values = this.createInternalArray(numberOfValues);
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                this.parseAndStoreElement(data, offset, charIndex, numberOfChars, optionalData, values, arrayIndex);
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            return this.convertListToArrayValue(values);
        }

        protected abstract T emptyElement();

        protected abstract E createInternalArray(int var1);

        protected abstract void parseAndStoreElement(char[] var1, int var2, int var3, int var4, CSVHeaderInformation var5, E var6, int var7);

        protected abstract T convertListToArrayValue(E var1);

        private int charsToNextDelimiter(char[] data, int offset, int length) {
            for (int i = 0; i < length; ++i) {
                if (data[offset + i] != this.arrayDelimiter) continue;
                return i;
            }
            return length;
        }

        private int numberOfValues(char[] data, int offset, int length) {
            int count = length > 0 ? 1 : 0;
            for (int i = 0; i < length; ++i) {
                if (data[offset + i] != this.arrayDelimiter) continue;
                ++count;
            }
            return count;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }

        @Override
        public boolean isEmpty(Object value) {
            return super.isEmpty(value) || value.getClass().isArray() && Array.getLength(value) == 0;
        }
    }

    private static abstract class AbstractExtractor<T>
    implements Extractor<T> {
        private final String name;
        private final Extractor<?> normalizedExtractor;

        AbstractExtractor(String name) {
            this(name, null);
        }

        AbstractExtractor(String name, Extractor<?> normalizedExtractor) {
            this.name = name;
            this.normalizedExtractor = normalizedExtractor;
        }

        @Override
        public T extract(char[] data, int offset, int length, boolean hadQuotes) {
            return this.extract(data, offset, length, hadQuotes, null);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Extractor<?> normalize() {
            return this.normalizedExtractor != null ? this.normalizedExtractor : this;
        }

        @Override
        public boolean isEmpty(Object value) {
            return value == null || value == Values.NO_VALUE;
        }

        public boolean equals(Object o) {
            return this == o || this.getClass().equals(o.getClass());
        }

        public int hashCode() {
            return Objects.hash(this.getClass());
        }
    }
}

