/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.event;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.neo4j.logging.event.EventsFilter;

class TimeBasedLimitedEventFilter
implements EventsFilter {
    private final Clock clock;
    private final Duration maxPublishPeriod;
    private Instant lastMiscEvent = Instant.MIN;

    TimeBasedLimitedEventFilter(Clock clock, Duration maxPublishPeriod) {
        this.clock = clock;
        this.maxPublishPeriod = maxPublishPeriod;
    }

    @Override
    public boolean canPublish() {
        Instant now = Instant.now(this.clock);
        boolean canPublish = now.isAfter(this.lastMiscEvent.plus(this.maxPublishPeriod));
        if (canPublish) {
            this.lastMiscEvent = now;
        }
        return canPublish;
    }
}

