/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.DuplicatingLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.internal.AbstractLogService;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.Neo4jLoggerContext;

public class SimpleLogService
extends AbstractLogService
implements Lifecycle {
    private final InternalLogProvider userLogProvider;
    private final InternalLogProvider internalLogProvider;

    public SimpleLogService(InternalLogProvider commonLogProvider) {
        this(commonLogProvider, commonLogProvider, false);
    }

    public SimpleLogService(InternalLogProvider userLogProvider, InternalLogProvider internalLogProvider) {
        this(userLogProvider, internalLogProvider, false);
    }

    public SimpleLogService(InternalLogProvider userLogProvider, InternalLogProvider internalLogProvider, boolean duplicate) {
        this.userLogProvider = duplicate ? new DuplicatingLogProvider(userLogProvider, internalLogProvider) : userLogProvider;
        this.internalLogProvider = internalLogProvider;
    }

    public SimpleLogService(Neo4jLoggerContext ctx) {
        this(new Log4jLogProvider(ctx));
    }

    @Override
    public InternalLogProvider getUserLogProvider() {
        return this.userLogProvider;
    }

    @Override
    public InternalLogProvider getInternalLogProvider() {
        return this.internalLogProvider;
    }

    public void init() {
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
        if (this.internalLogProvider instanceof Log4jLogProvider) {
            this.internalLogProvider.close();
        }
    }
}

