/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.Neo4jLogMessage;
import org.neo4j.logging.log4j.Neo4jLogMarker;

public class Log4jLog
extends ExtendedLoggerWrapper
implements InternalLog {
    private final boolean internalErrorMarkersEnabled;

    Log4jLog(ExtendedLogger logger, boolean internalErrorMarkersEnabled) {
        super(logger, logger.getName(), logger.getMessageFactory());
        this.internalErrorMarkersEnabled = internalErrorMarkersEnabled;
    }

    Log4jLog(ExtendedLogger logger) {
        this(logger, false);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(Neo4jLogMessage message) {
        if (this.internalErrorMarkersEnabled) {
            Neo4jLogMarker marker = message.getMarker();
            this.logger.debug(marker != null ? marker.log4jMarker : null, (Message)message);
        } else {
            this.logger.debug((Message)message);
        }
    }

    @Override
    public void info(Neo4jLogMessage message) {
        if (this.internalErrorMarkersEnabled) {
            Neo4jLogMarker marker = message.getMarker();
            this.logger.info(marker != null ? marker.log4jMarker : null, (Message)message);
        } else {
            this.logger.info((Message)message);
        }
    }

    @Override
    public void warn(Neo4jLogMessage message) {
        if (this.internalErrorMarkersEnabled) {
            Neo4jLogMarker marker = message.getMarker();
            this.logger.warn(marker != null ? marker.log4jMarker : null, (Message)message);
        } else {
            this.logger.warn((Message)message);
        }
    }

    @Override
    public void error(Neo4jLogMessage message) {
        if (this.internalErrorMarkersEnabled) {
            Neo4jLogMarker marker = message.getMarker();
            this.logger.error(marker != null ? marker.log4jMarker : null, (Message)message);
        } else {
            this.logger.error((Message)message);
        }
    }

    @Override
    public void error(Neo4jLogMessage message, Throwable throwable) {
        if (this.internalErrorMarkersEnabled) {
            Neo4jLogMarker marker = message.getMarker();
            this.logger.error(marker != null ? marker.log4jMarker : null, (Message)message, throwable);
        } else {
            this.logger.error((Message)message, throwable);
        }
    }
}

