/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.function.Consumer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.DefaultLogEventFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.neo4j.exceptions.UnsatisfiedDependencyException;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.log4j.Log4jLog;

@Plugin(name="Neo4jDebugLogLayout", category="Core", elementType="layout", printObject=true)
public class Neo4jDebugLogLayout
extends AbstractStringLayout {
    private final AbstractStringLayout.Serializer eventSerializer;
    private volatile Consumer<InternalLog> headerLogger;
    private volatile String headerClassName;

    private Neo4jDebugLogLayout(String pattern, Configuration config) {
        super(config, StandardCharsets.UTF_8, null, null);
        this.eventSerializer = PatternLayout.newSerializerBuilder().setConfiguration(config).setAlwaysWriteExceptions(true).setDisableAnsi(false).setNoConsoleNoAnsi(false).setPattern(pattern).build();
    }

    @PluginFactory
    public static Neo4jDebugLogLayout createLayout(@PluginAttribute(value="pattern") String pattern, @PluginConfiguration Configuration config) {
        return new Neo4jDebugLogLayout(pattern, config);
    }

    public byte[] getHeader() {
        if (this.headerLogger == null) {
            return super.getHeader();
        }
        ByteArrayLogger byteArrayLogger = new ByteArrayLogger();
        Log4jLog log = new Log4jLog((ExtendedLogger)byteArrayLogger);
        try {
            this.headerLogger.accept(log);
        }
        catch (UnsatisfiedDependencyException unsatisfiedDependencyException) {
            // empty catch block
        }
        return byteArrayLogger.getBytes();
    }

    public String toSerializable(LogEvent event) {
        return this.eventSerializer.toSerializable(event);
    }

    public void setHeaderLogger(Consumer<InternalLog> headerLogger, String className) {
        this.headerLogger = headerLogger;
        this.headerClassName = className;
    }

    private class ByteArrayLogger
    extends AbstractLogger {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();

        private ByteArrayLogger() {
        }

        public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, CharSequence message, Throwable t) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
            return true;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
            return true;
        }

        public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
            String logMsg = Neo4jDebugLogLayout.this.toSerializable(DefaultLogEventFactory.getInstance().createEvent(Neo4jDebugLogLayout.this.headerClassName, marker, fqcn, level, message, Collections.emptyList(), t));
            try {
                this.baos.write(logMsg.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public Level getLevel() {
            return null;
        }

        public byte[] getBytes() {
            return this.baos.toByteArray();
        }
    }
}

