/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import io.grpc.stub.StreamObserver;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.grpc.StatusUtils;
import org.apache.arrow.util.AutoCloseables;

class StreamPipe<FROM, TO>
implements FlightProducer.StreamListener<FROM> {
    private final StreamObserver<TO> delegate;
    private final Function<FROM, TO> mapFunction;
    private final Consumer<Throwable> errorHandler;
    private AutoCloseable resource;
    private boolean closed = false;

    public static <FROM, TO> StreamPipe<FROM, TO> wrap(StreamObserver<TO> delegate, Function<FROM, TO> func, Consumer<Throwable> errorHandler) {
        return new StreamPipe<FROM, TO>(delegate, func, errorHandler);
    }

    public StreamPipe(StreamObserver<TO> delegate, Function<FROM, TO> func, Consumer<Throwable> errorHandler) {
        this.delegate = delegate;
        this.mapFunction = func;
        this.errorHandler = errorHandler;
        this.resource = null;
    }

    void setAutoCloseable(AutoCloseable ac) {
        this.resource = ac;
    }

    @Override
    public void onNext(FROM val) {
        this.delegate.onNext(this.mapFunction.apply(val));
    }

    @Override
    public void onError(Throwable t) {
        if (this.closed) {
            this.errorHandler.accept(t);
            return;
        }
        try {
            AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.resource});
        }
        catch (Exception e) {
            this.errorHandler.accept(e);
        }
        finally {
            this.closed = true;
            this.delegate.onError(StatusUtils.toGrpcException(t));
        }
    }

    @Override
    public void onCompleted() {
        if (this.closed) {
            this.errorHandler.accept(new IllegalStateException("Tried to complete already-completed call"));
            return;
        }
        try {
            AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.resource});
        }
        catch (Exception e) {
            this.errorHandler.accept(e);
        }
        finally {
            this.closed = true;
            this.delegate.onCompleted();
        }
    }

    void ensureCompleted() {
        if (!this.closed) {
            this.onCompleted();
        }
    }
}

