/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.auth2;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.auth2.AuthUtilities;
import org.apache.arrow.flight.auth2.CallHeaderAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCallHeaderAuthenticator
implements CallHeaderAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(BasicCallHeaderAuthenticator.class);
    private final CredentialValidator authValidator;

    public BasicCallHeaderAuthenticator(CredentialValidator authValidator) {
        this.authValidator = authValidator;
    }

    @Override
    public CallHeaderAuthenticator.AuthResult authenticate(CallHeaders incomingHeaders) {
        try {
            String authEncoded = AuthUtilities.getValueFromAuthHeader(incomingHeaders, "Basic ");
            if (authEncoded == null) {
                throw CallStatus.UNAUTHENTICATED.toRuntimeException();
            }
            String authDecoded = new String(Base64.getDecoder().decode(authEncoded), StandardCharsets.UTF_8);
            int colonPos = authDecoded.indexOf(58);
            if (colonPos == -1) {
                throw CallStatus.UNAUTHENTICATED.toRuntimeException();
            }
            String user = authDecoded.substring(0, colonPos);
            String password = authDecoded.substring(colonPos + 1);
            return this.authValidator.validate(user, password);
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("Authentication failed due to missing encoding.", (Throwable)ex);
            throw CallStatus.INTERNAL.toRuntimeException();
        }
        catch (FlightRuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error("Authentication failed.", (Throwable)ex);
            throw CallStatus.UNAUTHENTICATED.toRuntimeException();
        }
    }

    public static interface CredentialValidator {
        public CallHeaderAuthenticator.AuthResult validate(String var1, String var2) throws Exception;
    }
}

