/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.jolt.v2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.neo4j.server.http.cypher.format.jolt.JoltRelationship;
import org.neo4j.server.http.cypher.format.jolt.Sigil;

final class JoltRelationshipReversedSerializerV2
extends StdSerializer<JoltRelationship> {
    JoltRelationshipReversedSerializerV2() {
        super(JoltRelationship.class);
    }

    public void serialize(JoltRelationship relationship, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject((Object)relationship);
        generator.writeFieldName(Sigil.RELATIONSHIP_REVERSED.getValue());
        generator.writeStartArray();
        generator.writeString(relationship.getElementId());
        generator.writeString(relationship.getStartNodeElementId());
        generator.writeString(relationship.getType().name());
        generator.writeString(relationship.getEndNodeElementId());
        Map properties = Optional.ofNullable(relationship.getAllProperties()).orElseGet(Map::of);
        generator.writeStartObject();
        for (Map.Entry entry : properties.entrySet()) {
            generator.writeFieldName((String)entry.getKey());
            generator.writeObject(entry.getValue());
        }
        generator.writeEndObject();
        generator.writeEndArray();
        generator.writeEndObject();
    }
}

