/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.queryapi.QueryResource;
import org.neo4j.server.queryapi.metrics.QueryAPIMetricsFilter;
import org.neo4j.server.queryapi.metrics.QueryAPIMetricsMonitor;
import org.neo4j.server.queryapi.request.JsonMessageBodyReader;
import org.neo4j.server.queryapi.request.TypedJsonMessageBodyReader;
import org.neo4j.server.queryapi.response.PlainJsonDriverAutoCommitResultWriter;
import org.neo4j.server.queryapi.response.PlainJsonTxManagingResultWriter;
import org.neo4j.server.queryapi.response.TypedJsonBookmarkWriter;
import org.neo4j.server.queryapi.response.TypedJsonDriverAutoCommitResultWriter;
import org.neo4j.server.queryapi.response.TypedJsonTxInfoWriter;
import org.neo4j.server.queryapi.response.TypedJsonTxManagingResultWriter;
import org.neo4j.server.queryapi.response.error.ErrorResponseWriter;
import org.neo4j.server.queryapi.response.error.InternalServerExceptionMapper;
import org.neo4j.server.queryapi.response.error.Neo4jExceptionMapper;
import org.neo4j.server.queryapi.response.error.QueryApiExceptionMapper;
import org.neo4j.server.queryapi.response.error.WebApplicationExceptionMapper;
import org.neo4j.server.web.WebServer;

public class QueryModule
implements ServerModule {
    private final WebServer webServer;
    private final Config config;
    private final QueryAPIMetricsMonitor metricsMonitor;

    public QueryModule(WebServer webServer, Config config, QueryAPIMetricsMonitor metricsMonitor) {
        this.webServer = webServer;
        this.config = config;
        this.metricsMonitor = metricsMonitor;
    }

    @Override
    public void start() {
        this.webServer.addJAXRSClasses(QueryModule.jaxRsClasses(), ((URI)this.config.get(ServerSettings.db_api_path)).toString(), null);
        this.webServer.addFilter(new QueryAPIMetricsFilter(this.metricsMonitor), "/*");
    }

    @Override
    public void stop() {
        this.webServer.removeJAXRSClasses(QueryModule.jaxRsClasses(), ((URI)this.config.get(ServerSettings.db_api_path)).toString());
    }

    private static List<Class<?>> jaxRsClasses() {
        return List.of(QueryResource.class, PlainJsonDriverAutoCommitResultWriter.class, TypedJsonDriverAutoCommitResultWriter.class, PlainJsonTxManagingResultWriter.class, TypedJsonTxManagingResultWriter.class, TypedJsonTxInfoWriter.class, TypedJsonBookmarkWriter.class, JsonMessageBodyReader.class, TypedJsonMessageBodyReader.class, Neo4jExceptionMapper.class, QueryApiExceptionMapper.class, WebApplicationExceptionMapper.class, InternalServerExceptionMapper.class, ErrorResponseWriter.class);
    }
}

