/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.queryapi.QueryController;
import org.neo4j.server.queryapi.metrics.QueryAPIMetricsMonitor;
import org.neo4j.server.queryapi.request.AccessMode;
import org.neo4j.server.queryapi.request.QueryRequest;
import org.neo4j.server.queryapi.response.error.HttpErrorResponse;

@Path(value="/{databaseName}/query/v2")
@Produces(value={"application/json", "application/vnd.neo4j.query", "application/vnd.neo4j.query.v1.0"})
@Consumes(value={"application/json", "application/vnd.neo4j.query", "application/vnd.neo4j.query.v1.0"})
public class QueryResource {
    public static final String NAME = "query";
    private static final String DB_PATH_PARAM_NAME = "databaseName";
    private static final String TX_ID_PATH_PARAM_NAME = "txId";
    public static final String ROOT_PATH = "/{databaseName}/query/v2";
    private final QueryAPIMetricsMonitor monitor;
    private final QueryController queryController;

    public QueryResource(@Context QueryController queryController, @Context QueryAPIMetricsMonitor monitor) {
        this.queryController = queryController;
        this.monitor = monitor;
    }

    @POST
    public Response execute(@PathParam(value="databaseName") String databaseName, QueryRequest request, @Context HttpServletRequest rawRequest, @Context HttpHeaders headers) {
        this.meterRequest(request);
        Response clientErrorResponse = QueryResource.validateRequest(request);
        if (clientErrorResponse != null) {
            return clientErrorResponse;
        }
        return this.queryController.executeQuery(request, rawRequest, databaseName);
    }

    @POST
    @Path(value="/tx")
    public Response beginTransaction(@PathParam(value="databaseName") String databaseName, QueryRequest request, @Context HttpServletRequest rawRequest, @Context HttpHeaders headers) {
        this.meterRequest(request);
        return this.queryController.beginTransaction(request, rawRequest, databaseName);
    }

    @POST
    @Path(value="tx/{txId}")
    public Response continueTransaction(@PathParam(value="databaseName") String databaseName, @PathParam(value="txId") String requestedTxId, QueryRequest request, @Context HttpServletRequest rawRequest, @Context HttpHeaders headers) {
        this.meterRequest(request);
        return this.queryController.continueTransaction(request, rawRequest, databaseName, requestedTxId);
    }

    @POST
    @Path(value="tx/{txId}/commit")
    public Response commitTransaction(@PathParam(value="databaseName") String databaseName, @PathParam(value="txId") String txId, QueryRequest request, @Context HttpServletRequest rawRequest, @Context HttpHeaders headers) {
        this.meterRequest(request);
        return this.queryController.commitTransaction(request, rawRequest, databaseName, txId);
    }

    @DELETE
    @Path(value="tx/{txId}")
    public Response rollbackTransaction(@PathParam(value="databaseName") String databaseName, @PathParam(value="txId") String txId, QueryRequest request, @Context HttpServletRequest rawRequest, @Context HttpHeaders headers) {
        return this.queryController.rollbackTransaction(txId, rawRequest, databaseName);
    }

    public static String absoluteDatabaseTransactionPath(Config config) {
        return ((URI)config.get(ServerSettings.db_api_path)).getPath() + ROOT_PATH;
    }

    private void meterRequest(QueryRequest request) {
        if (request.accessMode() != null && request.accessMode().equals((Object)AccessMode.READ)) {
            this.monitor.readRequest();
        }
        if (request.parameters() != null && !request.parameters().isEmpty()) {
            this.monitor.parameter();
        }
    }

    private static Response validateRequest(QueryRequest request) {
        if (request.statement() == null || request.statement().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)HttpErrorResponse.singleError(Status.Request.Invalid.code().serialize(), "statement cannot be null or empty")).build();
        }
        return null;
    }
}

