/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.request;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.value.NullValue;
import org.neo4j.server.queryapi.exception.QueryApiException;

public class ParameterDeserializer
extends StdDeserializer<Map<String, Object>> {
    public ParameterDeserializer() {
        super((JavaType)TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class));
    }

    public Map<String, Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String keyString;
        HashMap<String, Object> map = new HashMap<String, Object>();
        JsonToken t = p.currentToken();
        if (t != JsonToken.START_OBJECT && t != JsonToken.FIELD_NAME) {
            throw new JsonParseException("Unexpected token");
        }
        if (p.isExpectedStartObjectToken()) {
            keyString = p.nextFieldName();
        } else {
            JsonToken token = p.currentToken();
            if (token == JsonToken.END_OBJECT) {
                return map;
            }
            if (token != JsonToken.FIELD_NAME) {
                ctxt.reportWrongTokenException((JsonDeserializer)this, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            keyString = p.currentName();
        }
        while (keyString != null) {
            JsonToken nextToken = p.nextToken();
            try {
                if (nextToken == JsonToken.VALUE_NULL) {
                    map.put(keyString, NullValue.NULL);
                } else {
                    Value value = (Value)p.readValueAs(Value.class);
                    map.put(keyString, value);
                }
            }
            catch (QueryApiException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonParseException(String.format("Unable to read value for field %s", keyString));
            }
            keyString = p.nextFieldName();
        }
        return map;
    }
}

