/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.response.error;

import java.util.List;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.server.queryapi.exception.QueryApiException;
import org.neo4j.server.queryapi.response.error.HttpError;

public record HttpErrorResponse(List<HttpError> errors) {
    @Deprecated(forRemoval=true)
    public static HttpErrorResponse singleError(String error, String message) {
        return new HttpErrorResponse(List.of(new HttpError(error, message)));
    }

    public static HttpErrorResponse fromDriverException(Neo4jException neo4jException) {
        return new HttpErrorResponse(List.of(new HttpError(neo4jException.code(), neo4jException.getMessage())));
    }

    public static HttpErrorResponse fromQueryApiException(QueryApiException queryApiException) {
        return new HttpErrorResponse(List.of(new HttpError(queryApiException.status().code().serialize(), queryApiException.getMessage())));
    }
}

