/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.response.error;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.FatalDiscoveryException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.server.queryapi.response.error.HttpErrorResponse;

public class Neo4jExceptionMapper
implements ExceptionMapper<Neo4jException> {
    public Response toResponse(Neo4jException e) {
        return Response.status((Response.Status)Neo4jExceptionMapper.status(e)).entity((Object)HttpErrorResponse.fromDriverException(e)).build();
    }

    private static Response.Status status(Neo4jException e) {
        if (e instanceof FatalDiscoveryException) {
            return Response.Status.NOT_FOUND;
        }
        if (e instanceof ClientException || e instanceof TransientException) {
            return Response.Status.BAD_REQUEST;
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }
}

