/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.response.format;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalIsoDuration;
import org.neo4j.driver.types.IsoDuration;
import org.neo4j.driver.types.Point;
import org.neo4j.values.storable.DurationValue;

public enum CypherTypes {
    Null,
    List,
    Map,
    Boolean,
    Integer(Long::parseLong, Value::toString),
    Float(Double::parseDouble, Value::toString),
    String(s -> s, Value::asString),
    Base64(v -> java.util.Base64.getDecoder().decode((String)v), v -> java.util.Base64.getEncoder().encodeToString(v.asByteArray())),
    Date(v -> LocalDate.parse(v, DateTimeFormatter.ISO_LOCAL_DATE), v -> DateTimeFormatter.ISO_LOCAL_DATE.format(v.asLocalDate())),
    Time(v -> OffsetTime.parse(v, DateTimeFormatter.ISO_OFFSET_TIME), v -> DateTimeFormatter.ISO_OFFSET_TIME.format(v.asOffsetTime())),
    LocalTime(v -> java.time.LocalTime.parse(v, DateTimeFormatter.ISO_LOCAL_TIME), v -> DateTimeFormatter.ISO_LOCAL_TIME.format(v.asLocalTime())),
    DateTime(v -> java.time.ZonedDateTime.parse(v, DateTimeFormatter.ISO_ZONED_DATE_TIME), v -> {
        if (v.asZonedDateTime().getZone().normalized() instanceof ZoneOffset) {
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(v.asOffsetDateTime());
        }
        return DateTimeFormatter.ISO_ZONED_DATE_TIME.format(v.asZonedDateTime());
    }),
    OffsetDateTime(v -> java.time.OffsetDateTime.parse(v, DateTimeFormatter.ISO_OFFSET_DATE_TIME), v -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(v.asOffsetDateTime())),
    ZonedDateTime(v -> java.time.ZonedDateTime.parse(v, DateTimeFormatter.ISO_ZONED_DATE_TIME), v -> DateTimeFormatter.ISO_ZONED_DATE_TIME.format(v.asZonedDateTime())),
    LocalDateTime(v -> java.time.LocalDateTime.parse(v, DateTimeFormatter.ISO_LOCAL_DATE_TIME), v -> DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(v.asLocalDateTime())),
    Duration(CypherTypes::parseDuration, v -> DurationValue.parse((CharSequence)v.asIsoDuration().toString()).toString()),
    Point(CypherTypes::parsePoint, v -> CypherTypes.serializePoint(v.asPoint())),
    Node,
    Relationship,
    Path;

    private final String value;
    private final Function<String, Value> reader;
    private final Function<Value, String> writer;
    private static final Pattern WKT_PATTERN;

    private CypherTypes() {
        this(null, null, null);
    }

    private CypherTypes(Function<String, Object> reader, Function<Value, String> writer) {
        this(null, reader, writer);
    }

    private CypherTypes(String value, Function<String, Object> reader, Function<Value, String> writer) {
        this.value = value == null ? this.name() : value;
        this.reader = reader == null ? null : reader.andThen(Values::value);
        this.writer = writer;
    }

    public String getValue() {
        return this.value;
    }

    public static Optional<CypherTypes> safeValueOf(String value) {
        try {
            return Optional.of(CypherTypes.valueOf(value));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static List<String> getTypeNames() {
        return Arrays.stream(CypherTypes.values()).map(CypherTypes::getValue).toList();
    }

    public Function<String, Value> getReader() {
        return this.reader;
    }

    public Function<Value, String> getWriter() {
        return this.writer;
    }

    private static Point parsePoint(String input) {
        Matcher matcher = WKT_PATTERN.matcher(input);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Illegal pattern");
        }
        int srid = java.lang.Integer.parseInt(matcher.group(1));
        double x = Double.parseDouble(matcher.group(2));
        double y = Double.parseDouble(matcher.group(3));
        String z = matcher.group(4);
        if (z != null && !z.isBlank()) {
            return Values.point((int)srid, (double)x, (double)y, (double)Double.parseDouble(z)).asPoint();
        }
        return Values.point((int)srid, (double)x, (double)y).asPoint();
    }

    private static IsoDuration parseDuration(String input) {
        DurationValue d = DurationValue.parse((CharSequence)input);
        return new InternalIsoDuration(d.get((TemporalUnit)ChronoUnit.MONTHS), d.get((TemporalUnit)ChronoUnit.DAYS), d.get((TemporalUnit)ChronoUnit.SECONDS), (int)d.get((TemporalUnit)ChronoUnit.NANOS));
    }

    private static String serializePoint(Point point) {
        boolean is3d = !Double.isNaN(point.z());
        return "SRID=" + point.srid() + ";POINT" + (is3d ? " Z " : " ") + "(" + point.x() + " " + point.y() + (String)(is3d ? " " + point.z() + ")" : ")");
    }

    static {
        WKT_PATTERN = Pattern.compile("SRID=(\\d+);\\s*POINT\\s*Z?\\s*\\(\\s*(\\S+)\\s+(\\S+)\\s*(\\S+)?\\)");
    }
}

