/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.internal.helpers.collection.IterableWrapper;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.Neo4jError;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.RepresentationType;

public class ExceptionRepresentation
extends MappingRepresentation {
    private final List<Neo4jError> errors = new LinkedList<Neo4jError>();
    private boolean includeLegacyRepresentation;

    public ExceptionRepresentation(Throwable exception) {
        this(exception, true);
    }

    public ExceptionRepresentation(Throwable exception, boolean includeLegacyRepresentation) {
        super(RepresentationType.EXCEPTION);
        this.errors.add(new Neo4jError(ExceptionRepresentation.statusCode(exception), exception));
        this.includeLegacyRepresentation = includeLegacyRepresentation;
    }

    protected void serialize(MappingSerializer serializer) {
        if (this.includeLegacyRepresentation) {
            ExceptionRepresentation.renderWithLegacyFormat(this.errors.get(0).cause(), serializer);
        }
        this.renderWithStatusCodeFormat(serializer);
    }

    private void renderWithStatusCodeFormat(MappingSerializer serializer) {
        serializer.putList("errors", ErrorEntryRepresentation.list(this.errors));
    }

    private static void renderWithLegacyFormat(Throwable exception, MappingSerializer serializer) {
        Throwable cause;
        String message = exception.getMessage();
        if (message != null) {
            serializer.putString("message", message);
        }
        serializer.putString("exception", exception.getClass().getSimpleName());
        serializer.putString("fullname", exception.getClass().getName());
        StackTraceElement[] trace = exception.getStackTrace();
        if (trace != null) {
            ArrayList<String> lines = new ArrayList<String>(trace.length);
            for (StackTraceElement element : trace) {
                if (element.toString().matches(".*(jetty|jersey|sun\\.reflect|mortbay|javax\\.servlet).*")) continue;
                lines.add(element.toString());
            }
            serializer.putList("stackTrace", ListRepresentation.string(lines));
        }
        if ((cause = exception.getCause()) != null) {
            serializer.putMapping("cause", (MappingRepresentation)new ExceptionRepresentation(cause));
        }
    }

    private static Status statusCode(Throwable current) {
        while (current != null) {
            if (current instanceof Status.HasStatus) {
                return ((Status.HasStatus)current).status();
            }
            if (current instanceof ConstraintViolationException) {
                return Status.Schema.ConstraintValidationFailed;
            }
            current = current.getCause();
        }
        return Status.General.UnknownError;
    }

    private static class ErrorEntryRepresentation
    extends MappingRepresentation {
        private final Neo4jError error;

        ErrorEntryRepresentation(Neo4jError error) {
            super("error-entry");
            this.error = error;
        }

        protected void serialize(MappingSerializer serializer) {
            serializer.putString("code", this.error.status().code().serialize());
            serializer.putString("message", this.error.getMessage());
        }

        public static ListRepresentation list(Collection<Neo4jError> errors) {
            return new ListRepresentation("error-list", (Iterable)new IterableWrapper<ErrorEntryRepresentation, Neo4jError>(errors){

                protected ErrorEntryRepresentation underlyingObjectToObject(Neo4jError error) {
                    return new ErrorEntryRepresentation(error);
                }
            });
        }
    }
}

