/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.server.rest.web.AbstractFilter;

public class AccessiblePathFilter
extends AbstractFilter {
    private final List<Pattern> blacklist;
    private final InternalLog log;

    public AccessiblePathFilter(InternalLogProvider logProvider, List<String> blacklist) {
        this.blacklist = blacklist.stream().map(Pattern::compile).toList();
        this.log = logProvider.getLog(this.getClass());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = AccessiblePathFilter.validateRequestType(servletRequest);
        HttpServletResponse response = AccessiblePathFilter.validateResponseType(servletResponse);
        String path = request.getContextPath() + (request.getPathInfo() == null ? "" : request.getPathInfo());
        if (this.blacklisted(path)) {
            this.log.debug("HTTP client '%s' trying to access a disabled server path: '%s'.", new Object[]{request.getRemoteAddr(), path});
            response.setStatus(Response.Status.FORBIDDEN.getStatusCode());
        } else {
            chain.doFilter(servletRequest, servletResponse);
        }
    }

    private boolean blacklisted(String path) {
        for (Pattern pattern : this.blacklist) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }
}

