/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.query;

import java.util.Set;
import org.neo4j.cypher.internal.cache.CacheSize;
import org.neo4j.cypher.internal.cache.CacheTracer;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.cache.CypherQueryCaches;
import org.neo4j.cypher.internal.cache.LFUCache;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.notification.InternalNotification;
import org.neo4j.cypher.internal.preparser.PreParsedQuery;
import org.neo4j.function.Observable;
import org.neo4j.router.impl.query.StatementType;
import org.neo4j.router.query.TargetService;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.virtual.MapValue;
import scala.Option;

public class ProcessedQueryInfoCache {
    public static final String MONITOR_TAG = "cypher.cache.router";
    private final boolean useParameterSizeHint;
    private final LFUCache<CypherQueryCaches.CacheKeyWithParameterType, Value> cache;

    @VisibleForTesting
    public ProcessedQueryInfoCache(CaffeineCacheFactory cacheFactory, Observable<Integer> cacheSize, boolean useParameterSizeHint, CacheTracer<CypherQueryCaches.CacheKeyWithParameterType> tracer) {
        this.useParameterSizeHint = useParameterSizeHint;
        this.cache = new LFUCache(cacheFactory, (CacheSize)new CacheSize.Dynamic(cacheSize), tracer);
    }

    public ProcessedQueryInfoCache(CaffeineCacheFactory cacheFactory, int cacheSize, CacheTracer<CypherQueryCaches.CacheKeyWithParameterType> tracer) {
        this.useParameterSizeHint = true;
        this.cache = new LFUCache(cacheFactory, (CacheSize)new CacheSize.Static(cacheSize), tracer);
    }

    public Value get(PreParsedQuery query, MapValue parameters) {
        Option maybeValue = this.cache.get((Object)CypherQueryCaches.astKeyRawQuery((PreParsedQuery)query, (MapValue)parameters, (boolean)this.useParameterSizeHint));
        if (maybeValue.isEmpty()) {
            return null;
        }
        return (Value)maybeValue.get();
    }

    public void put(PreParsedQuery query, MapValue parameters, Value value) {
        this.cache.put((Object)CypherQueryCaches.astKeyRawQuery((PreParsedQuery)query, (MapValue)parameters, (boolean)this.useParameterSizeHint), (Object)value);
    }

    public long clearQueryCachesForDatabase(String databaseName) {
        long size = this.cache.estimatedSize();
        this.cache.clear();
        return size;
    }

    public record Value(TargetService.CatalogInfo catalogInfo, String rewrittenQueryText, MapValue maybeExtractedParams, PreParsedQuery preParsedQuery, BaseState parsedQuery, StatementType statementType, Set<InternalNotification> parsingNotifications) {
    }
}

